// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Represents a metric value.
 */
@Fluent
public final class MetricValue implements JsonSerializable<MetricValue> {
    /*
     * the timestamp for the metric value in ISO 8601 format.
     */
    private OffsetDateTime timestamp;

    /*
     * the average value in the time range.
     */
    private Double average;

    /*
     * the least value in the time range.
     */
    private Double minimum;

    /*
     * the greatest value in the time range.
     */
    private Double maximum;

    /*
     * the sum of all of the values in the time range.
     */
    private Double total;

    /*
     * the number of samples in the time range. Can be used to determine the number of values that contributed to the
     * average value.
     */
    private Double count;

    /**
     * Creates an instance of MetricValue class.
     */
    public MetricValue() {
    }

    /**
     * Get the timestamp property: the timestamp for the metric value in ISO 8601 format.
     * 
     * @return the timestamp value.
     */
    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    /**
     * Set the timestamp property: the timestamp for the metric value in ISO 8601 format.
     * 
     * @param timestamp the timestamp value to set.
     * @return the MetricValue object itself.
     */
    public MetricValue withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    /**
     * Get the average property: the average value in the time range.
     * 
     * @return the average value.
     */
    public Double average() {
        return this.average;
    }

    /**
     * Set the average property: the average value in the time range.
     * 
     * @param average the average value to set.
     * @return the MetricValue object itself.
     */
    public MetricValue withAverage(Double average) {
        this.average = average;
        return this;
    }

    /**
     * Get the minimum property: the least value in the time range.
     * 
     * @return the minimum value.
     */
    public Double minimum() {
        return this.minimum;
    }

    /**
     * Set the minimum property: the least value in the time range.
     * 
     * @param minimum the minimum value to set.
     * @return the MetricValue object itself.
     */
    public MetricValue withMinimum(Double minimum) {
        this.minimum = minimum;
        return this;
    }

    /**
     * Get the maximum property: the greatest value in the time range.
     * 
     * @return the maximum value.
     */
    public Double maximum() {
        return this.maximum;
    }

    /**
     * Set the maximum property: the greatest value in the time range.
     * 
     * @param maximum the maximum value to set.
     * @return the MetricValue object itself.
     */
    public MetricValue withMaximum(Double maximum) {
        this.maximum = maximum;
        return this;
    }

    /**
     * Get the total property: the sum of all of the values in the time range.
     * 
     * @return the total value.
     */
    public Double total() {
        return this.total;
    }

    /**
     * Set the total property: the sum of all of the values in the time range.
     * 
     * @param total the total value to set.
     * @return the MetricValue object itself.
     */
    public MetricValue withTotal(Double total) {
        this.total = total;
        return this;
    }

    /**
     * Get the count property: the number of samples in the time range. Can be used to determine the number of values
     * that contributed to the average value.
     * 
     * @return the count value.
     */
    public Double count() {
        return this.count;
    }

    /**
     * Set the count property: the number of samples in the time range. Can be used to determine the number of values
     * that contributed to the average value.
     * 
     * @param count the count value to set.
     * @return the MetricValue object itself.
     */
    public MetricValue withCount(Double count) {
        this.count = count;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (timestamp() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property timestamp in model MetricValue"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(MetricValue.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timeStamp",
            this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeNumberField("average", this.average);
        jsonWriter.writeNumberField("minimum", this.minimum);
        jsonWriter.writeNumberField("maximum", this.maximum);
        jsonWriter.writeNumberField("total", this.total);
        jsonWriter.writeNumberField("count", this.count);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MetricValue from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MetricValue if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MetricValue.
     */
    public static MetricValue fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetricValue deserializedMetricValue = new MetricValue();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("timeStamp".equals(fieldName)) {
                    deserializedMetricValue.timestamp = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("average".equals(fieldName)) {
                    deserializedMetricValue.average = reader.getNullable(JsonReader::getDouble);
                } else if ("minimum".equals(fieldName)) {
                    deserializedMetricValue.minimum = reader.getNullable(JsonReader::getDouble);
                } else if ("maximum".equals(fieldName)) {
                    deserializedMetricValue.maximum = reader.getNullable(JsonReader::getDouble);
                } else if ("total".equals(fieldName)) {
                    deserializedMetricValue.total = reader.getNullable(JsonReader::getDouble);
                } else if ("count".equals(fieldName)) {
                    deserializedMetricValue.count = reader.getNullable(JsonReader::getDouble);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMetricValue;
        });
    }
}
