// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * An alert status.
 */
@Fluent
public final class MetricAlertStatus implements JsonSerializable<MetricAlertStatus> {
    /*
     * The status name.
     */
    private String name;

    /*
     * The alert rule arm id.
     */
    private String id;

    /*
     * The extended resource type name.
     */
    private String type;

    /*
     * The alert status properties of the metric alert status.
     */
    private MetricAlertStatusProperties properties;

    /**
     * Creates an instance of MetricAlertStatus class.
     */
    public MetricAlertStatus() {
    }

    /**
     * Get the name property: The status name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The status name.
     * 
     * @param name the name value to set.
     * @return the MetricAlertStatus object itself.
     */
    public MetricAlertStatus withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the id property: The alert rule arm id.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The alert rule arm id.
     * 
     * @param id the id value to set.
     * @return the MetricAlertStatus object itself.
     */
    public MetricAlertStatus withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the type property: The extended resource type name.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: The extended resource type name.
     * 
     * @param type the type value to set.
     * @return the MetricAlertStatus object itself.
     */
    public MetricAlertStatus withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the properties property: The alert status properties of the metric alert status.
     * 
     * @return the properties value.
     */
    public MetricAlertStatusProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: The alert status properties of the metric alert status.
     * 
     * @param properties the properties value to set.
     * @return the MetricAlertStatus object itself.
     */
    public MetricAlertStatus withProperties(MetricAlertStatusProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MetricAlertStatus from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MetricAlertStatus if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the MetricAlertStatus.
     */
    public static MetricAlertStatus fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetricAlertStatus deserializedMetricAlertStatus = new MetricAlertStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedMetricAlertStatus.name = reader.getString();
                } else if ("id".equals(fieldName)) {
                    deserializedMetricAlertStatus.id = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedMetricAlertStatus.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedMetricAlertStatus.properties = MetricAlertStatusProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMetricAlertStatus;
        });
    }
}
