// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information about a container with data for a given resource.
 */
@Fluent
public final class DataContainer implements JsonSerializable<DataContainer> {
    /*
     * Log Analytics workspace information.
     */
    private WorkspaceInfo workspace;

    /**
     * Creates an instance of DataContainer class.
     */
    public DataContainer() {
    }

    /**
     * Get the workspace property: Log Analytics workspace information.
     * 
     * @return the workspace value.
     */
    public WorkspaceInfo workspace() {
        return this.workspace;
    }

    /**
     * Set the workspace property: Log Analytics workspace information.
     * 
     * @param workspace the workspace value to set.
     * @return the DataContainer object itself.
     */
    public DataContainer withWorkspace(WorkspaceInfo workspace) {
        this.workspace = workspace;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (workspace() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property workspace in model DataContainer"));
        } else {
            workspace().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DataContainer.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("workspace", this.workspace);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DataContainer from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DataContainer if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DataContainer.
     */
    public static DataContainer fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataContainer deserializedDataContainer = new DataContainer();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("workspace".equals(fieldName)) {
                    deserializedDataContainer.workspace = WorkspaceInfo.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDataContainer;
        });
    }
}
