// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Definition of custom data column.
 */
@Fluent
public final class ColumnDefinition {
    /*
     * The name of the column.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * The type of the column data.
     */
    @JsonProperty(value = "type")
    private KnownColumnDefinitionType type;

    /**
     * Creates an instance of ColumnDefinition class.
     */
    public ColumnDefinition() {
    }

    /**
     * Get the name property: The name of the column.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the column.
     * 
     * @param name the name value to set.
     * @return the ColumnDefinition object itself.
     */
    public ColumnDefinition withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: The type of the column data.
     * 
     * @return the type value.
     */
    public KnownColumnDefinitionType type() {
        return this.type;
    }

    /**
     * Set the type property: The type of the column data.
     * 
     * @param type the type value to set.
     * @return the ColumnDefinition object itself.
     */
    public ColumnDefinition withType(KnownColumnDefinitionType type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
