// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The request body which contain contact detail metadata.
 */
@Fluent
public final class NotificationRequestBody {
    /*
     * The value of the supported alert type. Supported alert type values are: servicehealth, metricstaticthreshold,
     * metricsdynamicthreshold, logalertv2, smartalert, webtestalert, logalertv1numresult, logalertv1metricmeasurement,
     * resourcehealth, activitylog, actualcostbudget, forecastedbudget
     */
    @JsonProperty(value = "alertType", required = true)
    private String alertType;

    /*
     * The list of email receivers that are part of this action group.
     */
    @JsonProperty(value = "emailReceivers")
    private List<EmailReceiver> emailReceivers;

    /*
     * The list of SMS receivers that are part of this action group.
     */
    @JsonProperty(value = "smsReceivers")
    private List<SmsReceiver> smsReceivers;

    /*
     * The list of webhook receivers that are part of this action group.
     */
    @JsonProperty(value = "webhookReceivers")
    private List<WebhookReceiver> webhookReceivers;

    /*
     * The list of ITSM receivers that are part of this action group.
     */
    @JsonProperty(value = "itsmReceivers")
    private List<ItsmReceiver> itsmReceivers;

    /*
     * The list of AzureAppPush receivers that are part of this action group.
     */
    @JsonProperty(value = "azureAppPushReceivers")
    private List<AzureAppPushReceiver> azureAppPushReceivers;

    /*
     * The list of AutomationRunbook receivers that are part of this action group.
     */
    @JsonProperty(value = "automationRunbookReceivers")
    private List<AutomationRunbookReceiver> automationRunbookReceivers;

    /*
     * The list of voice receivers that are part of this action group.
     */
    @JsonProperty(value = "voiceReceivers")
    private List<VoiceReceiver> voiceReceivers;

    /*
     * The list of logic app receivers that are part of this action group.
     */
    @JsonProperty(value = "logicAppReceivers")
    private List<LogicAppReceiver> logicAppReceivers;

    /*
     * The list of azure function receivers that are part of this action group.
     */
    @JsonProperty(value = "azureFunctionReceivers")
    private List<AzureFunctionReceiver> azureFunctionReceivers;

    /*
     * The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in
     * roles are supported.
     */
    @JsonProperty(value = "armRoleReceivers")
    private List<ArmRoleReceiver> armRoleReceivers;

    /*
     * The list of event hub receivers that are part of this action group.
     */
    @JsonProperty(value = "eventHubReceivers")
    private List<EventHubReceiver> eventHubReceivers;

    /**
     * Creates an instance of NotificationRequestBody class.
     */
    public NotificationRequestBody() {
    }

    /**
     * Get the alertType property: The value of the supported alert type. Supported alert type values are:
     * servicehealth, metricstaticthreshold, metricsdynamicthreshold, logalertv2, smartalert, webtestalert,
     * logalertv1numresult, logalertv1metricmeasurement, resourcehealth, activitylog, actualcostbudget,
     * forecastedbudget.
     * 
     * @return the alertType value.
     */
    public String alertType() {
        return this.alertType;
    }

    /**
     * Set the alertType property: The value of the supported alert type. Supported alert type values are:
     * servicehealth, metricstaticthreshold, metricsdynamicthreshold, logalertv2, smartalert, webtestalert,
     * logalertv1numresult, logalertv1metricmeasurement, resourcehealth, activitylog, actualcostbudget,
     * forecastedbudget.
     * 
     * @param alertType the alertType value to set.
     * @return the NotificationRequestBody object itself.
     */
    public NotificationRequestBody withAlertType(String alertType) {
        this.alertType = alertType;
        return this;
    }

    /**
     * Get the emailReceivers property: The list of email receivers that are part of this action group.
     * 
     * @return the emailReceivers value.
     */
    public List<EmailReceiver> emailReceivers() {
        return this.emailReceivers;
    }

    /**
     * Set the emailReceivers property: The list of email receivers that are part of this action group.
     * 
     * @param emailReceivers the emailReceivers value to set.
     * @return the NotificationRequestBody object itself.
     */
    public NotificationRequestBody withEmailReceivers(List<EmailReceiver> emailReceivers) {
        this.emailReceivers = emailReceivers;
        return this;
    }

    /**
     * Get the smsReceivers property: The list of SMS receivers that are part of this action group.
     * 
     * @return the smsReceivers value.
     */
    public List<SmsReceiver> smsReceivers() {
        return this.smsReceivers;
    }

    /**
     * Set the smsReceivers property: The list of SMS receivers that are part of this action group.
     * 
     * @param smsReceivers the smsReceivers value to set.
     * @return the NotificationRequestBody object itself.
     */
    public NotificationRequestBody withSmsReceivers(List<SmsReceiver> smsReceivers) {
        this.smsReceivers = smsReceivers;
        return this;
    }

    /**
     * Get the webhookReceivers property: The list of webhook receivers that are part of this action group.
     * 
     * @return the webhookReceivers value.
     */
    public List<WebhookReceiver> webhookReceivers() {
        return this.webhookReceivers;
    }

    /**
     * Set the webhookReceivers property: The list of webhook receivers that are part of this action group.
     * 
     * @param webhookReceivers the webhookReceivers value to set.
     * @return the NotificationRequestBody object itself.
     */
    public NotificationRequestBody withWebhookReceivers(List<WebhookReceiver> webhookReceivers) {
        this.webhookReceivers = webhookReceivers;
        return this;
    }

    /**
     * Get the itsmReceivers property: The list of ITSM receivers that are part of this action group.
     * 
     * @return the itsmReceivers value.
     */
    public List<ItsmReceiver> itsmReceivers() {
        return this.itsmReceivers;
    }

    /**
     * Set the itsmReceivers property: The list of ITSM receivers that are part of this action group.
     * 
     * @param itsmReceivers the itsmReceivers value to set.
     * @return the NotificationRequestBody object itself.
     */
    public NotificationRequestBody withItsmReceivers(List<ItsmReceiver> itsmReceivers) {
        this.itsmReceivers = itsmReceivers;
        return this;
    }

    /**
     * Get the azureAppPushReceivers property: The list of AzureAppPush receivers that are part of this action group.
     * 
     * @return the azureAppPushReceivers value.
     */
    public List<AzureAppPushReceiver> azureAppPushReceivers() {
        return this.azureAppPushReceivers;
    }

    /**
     * Set the azureAppPushReceivers property: The list of AzureAppPush receivers that are part of this action group.
     * 
     * @param azureAppPushReceivers the azureAppPushReceivers value to set.
     * @return the NotificationRequestBody object itself.
     */
    public NotificationRequestBody withAzureAppPushReceivers(List<AzureAppPushReceiver> azureAppPushReceivers) {
        this.azureAppPushReceivers = azureAppPushReceivers;
        return this;
    }

    /**
     * Get the automationRunbookReceivers property: The list of AutomationRunbook receivers that are part of this
     * action group.
     * 
     * @return the automationRunbookReceivers value.
     */
    public List<AutomationRunbookReceiver> automationRunbookReceivers() {
        return this.automationRunbookReceivers;
    }

    /**
     * Set the automationRunbookReceivers property: The list of AutomationRunbook receivers that are part of this
     * action group.
     * 
     * @param automationRunbookReceivers the automationRunbookReceivers value to set.
     * @return the NotificationRequestBody object itself.
     */
    public NotificationRequestBody
        withAutomationRunbookReceivers(List<AutomationRunbookReceiver> automationRunbookReceivers) {
        this.automationRunbookReceivers = automationRunbookReceivers;
        return this;
    }

    /**
     * Get the voiceReceivers property: The list of voice receivers that are part of this action group.
     * 
     * @return the voiceReceivers value.
     */
    public List<VoiceReceiver> voiceReceivers() {
        return this.voiceReceivers;
    }

    /**
     * Set the voiceReceivers property: The list of voice receivers that are part of this action group.
     * 
     * @param voiceReceivers the voiceReceivers value to set.
     * @return the NotificationRequestBody object itself.
     */
    public NotificationRequestBody withVoiceReceivers(List<VoiceReceiver> voiceReceivers) {
        this.voiceReceivers = voiceReceivers;
        return this;
    }

    /**
     * Get the logicAppReceivers property: The list of logic app receivers that are part of this action group.
     * 
     * @return the logicAppReceivers value.
     */
    public List<LogicAppReceiver> logicAppReceivers() {
        return this.logicAppReceivers;
    }

    /**
     * Set the logicAppReceivers property: The list of logic app receivers that are part of this action group.
     * 
     * @param logicAppReceivers the logicAppReceivers value to set.
     * @return the NotificationRequestBody object itself.
     */
    public NotificationRequestBody withLogicAppReceivers(List<LogicAppReceiver> logicAppReceivers) {
        this.logicAppReceivers = logicAppReceivers;
        return this;
    }

    /**
     * Get the azureFunctionReceivers property: The list of azure function receivers that are part of this action
     * group.
     * 
     * @return the azureFunctionReceivers value.
     */
    public List<AzureFunctionReceiver> azureFunctionReceivers() {
        return this.azureFunctionReceivers;
    }

    /**
     * Set the azureFunctionReceivers property: The list of azure function receivers that are part of this action
     * group.
     * 
     * @param azureFunctionReceivers the azureFunctionReceivers value to set.
     * @return the NotificationRequestBody object itself.
     */
    public NotificationRequestBody withAzureFunctionReceivers(List<AzureFunctionReceiver> azureFunctionReceivers) {
        this.azureFunctionReceivers = azureFunctionReceivers;
        return this;
    }

    /**
     * Get the armRoleReceivers property: The list of ARM role receivers that are part of this action group. Roles are
     * Azure RBAC roles and only built-in roles are supported.
     * 
     * @return the armRoleReceivers value.
     */
    public List<ArmRoleReceiver> armRoleReceivers() {
        return this.armRoleReceivers;
    }

    /**
     * Set the armRoleReceivers property: The list of ARM role receivers that are part of this action group. Roles are
     * Azure RBAC roles and only built-in roles are supported.
     * 
     * @param armRoleReceivers the armRoleReceivers value to set.
     * @return the NotificationRequestBody object itself.
     */
    public NotificationRequestBody withArmRoleReceivers(List<ArmRoleReceiver> armRoleReceivers) {
        this.armRoleReceivers = armRoleReceivers;
        return this;
    }

    /**
     * Get the eventHubReceivers property: The list of event hub receivers that are part of this action group.
     * 
     * @return the eventHubReceivers value.
     */
    public List<EventHubReceiver> eventHubReceivers() {
        return this.eventHubReceivers;
    }

    /**
     * Set the eventHubReceivers property: The list of event hub receivers that are part of this action group.
     * 
     * @param eventHubReceivers the eventHubReceivers value to set.
     * @return the NotificationRequestBody object itself.
     */
    public NotificationRequestBody withEventHubReceivers(List<EventHubReceiver> eventHubReceivers) {
        this.eventHubReceivers = eventHubReceivers;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (alertType() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property alertType in model NotificationRequestBody"));
        }
        if (emailReceivers() != null) {
            emailReceivers().forEach(e -> e.validate());
        }
        if (smsReceivers() != null) {
            smsReceivers().forEach(e -> e.validate());
        }
        if (webhookReceivers() != null) {
            webhookReceivers().forEach(e -> e.validate());
        }
        if (itsmReceivers() != null) {
            itsmReceivers().forEach(e -> e.validate());
        }
        if (azureAppPushReceivers() != null) {
            azureAppPushReceivers().forEach(e -> e.validate());
        }
        if (automationRunbookReceivers() != null) {
            automationRunbookReceivers().forEach(e -> e.validate());
        }
        if (voiceReceivers() != null) {
            voiceReceivers().forEach(e -> e.validate());
        }
        if (logicAppReceivers() != null) {
            logicAppReceivers().forEach(e -> e.validate());
        }
        if (azureFunctionReceivers() != null) {
            azureFunctionReceivers().forEach(e -> e.validate());
        }
        if (armRoleReceivers() != null) {
            armRoleReceivers().forEach(e -> e.validate());
        }
        if (eventHubReceivers() != null) {
            eventHubReceivers().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(NotificationRequestBody.class);
}
