// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Enables IIS logs to be collected by this data collection rule.
 */
@Fluent
public final class IisLogsDataSource {
    /*
     * IIS streams
     */
    @JsonProperty(value = "streams", required = true)
    private List<String> streams;

    /*
     * Absolute paths file location
     */
    @JsonProperty(value = "logDirectories")
    private List<String> logDirectories;

    /*
     * A friendly name for the data source.
     * This name should be unique across all data sources (regardless of type) within the data collection rule.
     */
    @JsonProperty(value = "name")
    private String name;

    /**
     * Creates an instance of IisLogsDataSource class.
     */
    public IisLogsDataSource() {
    }

    /**
     * Get the streams property: IIS streams.
     * 
     * @return the streams value.
     */
    public List<String> streams() {
        return this.streams;
    }

    /**
     * Set the streams property: IIS streams.
     * 
     * @param streams the streams value to set.
     * @return the IisLogsDataSource object itself.
     */
    public IisLogsDataSource withStreams(List<String> streams) {
        this.streams = streams;
        return this;
    }

    /**
     * Get the logDirectories property: Absolute paths file location.
     * 
     * @return the logDirectories value.
     */
    public List<String> logDirectories() {
        return this.logDirectories;
    }

    /**
     * Set the logDirectories property: Absolute paths file location.
     * 
     * @param logDirectories the logDirectories value to set.
     * @return the IisLogsDataSource object itself.
     */
    public IisLogsDataSource withLogDirectories(List<String> logDirectories) {
        this.logDirectories = logDirectories;
        return this;
    }

    /**
     * Get the name property: A friendly name for the data source.
     * This name should be unique across all data sources (regardless of type) within the data collection rule.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: A friendly name for the data source.
     * This name should be unique across all data sources (regardless of type) within the data collection rule.
     * 
     * @param name the name value to set.
     * @return the IisLogsDataSource object itself.
     */
    public IisLogsDataSource withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (streams() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property streams in model IisLogsDataSource"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(IisLogsDataSource.class);
}
