// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * The extent of deviation required to trigger an alert. This will affect how tight the threshold is to the metric
 * series pattern.
 */
public final class DynamicThresholdSensitivity extends ExpandableStringEnum<DynamicThresholdSensitivity> {
    /**
     * Static value Low for DynamicThresholdSensitivity.
     */
    public static final DynamicThresholdSensitivity LOW = fromString("Low");

    /**
     * Static value Medium for DynamicThresholdSensitivity.
     */
    public static final DynamicThresholdSensitivity MEDIUM = fromString("Medium");

    /**
     * Static value High for DynamicThresholdSensitivity.
     */
    public static final DynamicThresholdSensitivity HIGH = fromString("High");

    /**
     * Creates a new instance of DynamicThresholdSensitivity value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public DynamicThresholdSensitivity() {
    }

    /**
     * Creates or finds a DynamicThresholdSensitivity from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding DynamicThresholdSensitivity.
     */
    @JsonCreator
    public static DynamicThresholdSensitivity fromString(String name) {
        return fromString(name, DynamicThresholdSensitivity.class);
    }

    /**
     * Gets known DynamicThresholdSensitivity values.
     * 
     * @return known DynamicThresholdSensitivity values.
     */
    public static Collection<DynamicThresholdSensitivity> values() {
        return values(DynamicThresholdSensitivity.class);
    }
}
