// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Definition of which streams are sent to which destinations.
 */
@Fluent
public final class DataFlow {
    /*
     * List of streams for this data flow.
     */
    @JsonProperty(value = "streams")
    private List<KnownDataFlowStreams> streams;

    /*
     * List of destinations for this data flow.
     */
    @JsonProperty(value = "destinations")
    private List<String> destinations;

    /*
     * The KQL query to transform stream data.
     */
    @JsonProperty(value = "transformKql")
    private String transformKql;

    /*
     * The output stream of the transform. Only required if the transform changes data to a different stream.
     */
    @JsonProperty(value = "outputStream")
    private String outputStream;

    /**
     * Creates an instance of DataFlow class.
     */
    public DataFlow() {
    }

    /**
     * Get the streams property: List of streams for this data flow.
     * 
     * @return the streams value.
     */
    public List<KnownDataFlowStreams> streams() {
        return this.streams;
    }

    /**
     * Set the streams property: List of streams for this data flow.
     * 
     * @param streams the streams value to set.
     * @return the DataFlow object itself.
     */
    public DataFlow withStreams(List<KnownDataFlowStreams> streams) {
        this.streams = streams;
        return this;
    }

    /**
     * Get the destinations property: List of destinations for this data flow.
     * 
     * @return the destinations value.
     */
    public List<String> destinations() {
        return this.destinations;
    }

    /**
     * Set the destinations property: List of destinations for this data flow.
     * 
     * @param destinations the destinations value to set.
     * @return the DataFlow object itself.
     */
    public DataFlow withDestinations(List<String> destinations) {
        this.destinations = destinations;
        return this;
    }

    /**
     * Get the transformKql property: The KQL query to transform stream data.
     * 
     * @return the transformKql value.
     */
    public String transformKql() {
        return this.transformKql;
    }

    /**
     * Set the transformKql property: The KQL query to transform stream data.
     * 
     * @param transformKql the transformKql value to set.
     * @return the DataFlow object itself.
     */
    public DataFlow withTransformKql(String transformKql) {
        this.transformKql = transformKql;
        return this;
    }

    /**
     * Get the outputStream property: The output stream of the transform. Only required if the transform changes data
     * to a different stream.
     * 
     * @return the outputStream value.
     */
    public String outputStream() {
        return this.outputStream;
    }

    /**
     * Set the outputStream property: The output stream of the transform. Only required if the transform changes data
     * to a different stream.
     * 
     * @param outputStream the outputStream value to set.
     * @return the DataFlow object itself.
     */
    public DataFlow withOutputStream(String outputStream) {
        this.outputStream = outputStream;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
