// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A logic app receiver.
 */
@Fluent
public final class LogicAppReceiver {
    /*
     * The name of the logic app receiver. Names must be unique across all receivers within an action group.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /*
     * The azure resource id of the logic app receiver.
     */
    @JsonProperty(value = "resourceId", required = true)
    private String resourceId;

    /*
     * The callback url where http request sent to.
     */
    @JsonProperty(value = "callbackUrl", required = true)
    private String callbackUrl;

    /*
     * Indicates whether to use common alert schema.
     */
    @JsonProperty(value = "useCommonAlertSchema")
    private Boolean useCommonAlertSchema;

    /**
     * Creates an instance of LogicAppReceiver class.
     */
    public LogicAppReceiver() {
    }

    /**
     * Get the name property: The name of the logic app receiver. Names must be unique across all receivers within an
     * action group.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the logic app receiver. Names must be unique across all receivers within an
     * action group.
     * 
     * @param name the name value to set.
     * @return the LogicAppReceiver object itself.
     */
    public LogicAppReceiver withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the resourceId property: The azure resource id of the logic app receiver.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: The azure resource id of the logic app receiver.
     * 
     * @param resourceId the resourceId value to set.
     * @return the LogicAppReceiver object itself.
     */
    public LogicAppReceiver withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Get the callbackUrl property: The callback url where http request sent to.
     * 
     * @return the callbackUrl value.
     */
    public String callbackUrl() {
        return this.callbackUrl;
    }

    /**
     * Set the callbackUrl property: The callback url where http request sent to.
     * 
     * @param callbackUrl the callbackUrl value to set.
     * @return the LogicAppReceiver object itself.
     */
    public LogicAppReceiver withCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    /**
     * Get the useCommonAlertSchema property: Indicates whether to use common alert schema.
     * 
     * @return the useCommonAlertSchema value.
     */
    public Boolean useCommonAlertSchema() {
        return this.useCommonAlertSchema;
    }

    /**
     * Set the useCommonAlertSchema property: Indicates whether to use common alert schema.
     * 
     * @param useCommonAlertSchema the useCommonAlertSchema value to set.
     * @return the LogicAppReceiver object itself.
     */
    public LogicAppReceiver withUseCommonAlertSchema(Boolean useCommonAlertSchema) {
        this.useCommonAlertSchema = useCommonAlertSchema;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property name in model LogicAppReceiver"));
        }
        if (resourceId() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property resourceId in model LogicAppReceiver"));
        }
        if (callbackUrl() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property callbackUrl in model LogicAppReceiver"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(LogicAppReceiver.class);
}
