/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.fluent.models.ScheduledQueryRuleProperties;
import com.azure.resourcemanager.monitor.models.Actions;
import com.azure.resourcemanager.monitor.models.AlertSeverity;
import com.azure.resourcemanager.monitor.models.Kind;
import com.azure.resourcemanager.monitor.models.ScheduledQueryRuleCriteria;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.util.List;
import java.util.Map;

public final class ScheduledQueryRuleResourceInner
extends Resource {
    @JsonProperty(value="kind")
    private Kind kind;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;
    @JsonProperty(value="properties", required=true)
    private ScheduledQueryRuleProperties innerProperties = new ScheduledQueryRuleProperties();
    private static final ClientLogger LOGGER = new ClientLogger(ScheduledQueryRuleResourceInner.class);

    public Kind kind() {
        return this.kind;
    }

    public ScheduledQueryRuleResourceInner withKind(Kind kind) {
        this.kind = kind;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    private ScheduledQueryRuleProperties innerProperties() {
        return this.innerProperties;
    }

    public ScheduledQueryRuleResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ScheduledQueryRuleResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String createdWithApiVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().createdWithApiVersion();
    }

    public Boolean isLegacyLogAnalyticsRule() {
        return this.innerProperties() == null ? null : this.innerProperties().isLegacyLogAnalyticsRule();
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public ScheduledQueryRuleResourceInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    public ScheduledQueryRuleResourceInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    public AlertSeverity severity() {
        return this.innerProperties() == null ? null : this.innerProperties().severity();
    }

    public ScheduledQueryRuleResourceInner withSeverity(AlertSeverity severity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withSeverity(severity);
        return this;
    }

    public Boolean enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().enabled();
    }

    public ScheduledQueryRuleResourceInner withEnabled(Boolean enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    public List<String> scopes() {
        return this.innerProperties() == null ? null : this.innerProperties().scopes();
    }

    public ScheduledQueryRuleResourceInner withScopes(List<String> scopes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withScopes(scopes);
        return this;
    }

    public Duration evaluationFrequency() {
        return this.innerProperties() == null ? null : this.innerProperties().evaluationFrequency();
    }

    public ScheduledQueryRuleResourceInner withEvaluationFrequency(Duration evaluationFrequency) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withEvaluationFrequency(evaluationFrequency);
        return this;
    }

    public Duration windowSize() {
        return this.innerProperties() == null ? null : this.innerProperties().windowSize();
    }

    public ScheduledQueryRuleResourceInner withWindowSize(Duration windowSize) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withWindowSize(windowSize);
        return this;
    }

    public Duration overrideQueryTimeRange() {
        return this.innerProperties() == null ? null : this.innerProperties().overrideQueryTimeRange();
    }

    public ScheduledQueryRuleResourceInner withOverrideQueryTimeRange(Duration overrideQueryTimeRange) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withOverrideQueryTimeRange(overrideQueryTimeRange);
        return this;
    }

    public List<String> targetResourceTypes() {
        return this.innerProperties() == null ? null : this.innerProperties().targetResourceTypes();
    }

    public ScheduledQueryRuleResourceInner withTargetResourceTypes(List<String> targetResourceTypes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withTargetResourceTypes(targetResourceTypes);
        return this;
    }

    public ScheduledQueryRuleCriteria criteria() {
        return this.innerProperties() == null ? null : this.innerProperties().criteria();
    }

    public ScheduledQueryRuleResourceInner withCriteria(ScheduledQueryRuleCriteria criteria) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withCriteria(criteria);
        return this;
    }

    public Duration muteActionsDuration() {
        return this.innerProperties() == null ? null : this.innerProperties().muteActionsDuration();
    }

    public ScheduledQueryRuleResourceInner withMuteActionsDuration(Duration muteActionsDuration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withMuteActionsDuration(muteActionsDuration);
        return this;
    }

    public Actions actions() {
        return this.innerProperties() == null ? null : this.innerProperties().actions();
    }

    public ScheduledQueryRuleResourceInner withActions(Actions actions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withActions(actions);
        return this;
    }

    public Boolean isWorkspaceAlertsStorageConfigured() {
        return this.innerProperties() == null ? null : this.innerProperties().isWorkspaceAlertsStorageConfigured();
    }

    public Boolean checkWorkspaceAlertsStorageConfigured() {
        return this.innerProperties() == null ? null : this.innerProperties().checkWorkspaceAlertsStorageConfigured();
    }

    public ScheduledQueryRuleResourceInner withCheckWorkspaceAlertsStorageConfigured(Boolean checkWorkspaceAlertsStorageConfigured) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withCheckWorkspaceAlertsStorageConfigured(checkWorkspaceAlertsStorageConfigured);
        return this;
    }

    public Boolean skipQueryValidation() {
        return this.innerProperties() == null ? null : this.innerProperties().skipQueryValidation();
    }

    public ScheduledQueryRuleResourceInner withSkipQueryValidation(Boolean skipQueryValidation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withSkipQueryValidation(skipQueryValidation);
        return this;
    }

    public Boolean autoMitigate() {
        return this.innerProperties() == null ? null : this.innerProperties().autoMitigate();
    }

    public ScheduledQueryRuleResourceInner withAutoMitigate(Boolean autoMitigate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withAutoMitigate(autoMitigate);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model ScheduledQueryRuleResourceInner"));
        }
        this.innerProperties().validate();
    }
}

