// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** Represents a predictive metric value in the given bucket. */
@Fluent
public final class PredictiveValue {
    /*
     * the timestamp for the metric value in ISO 8601 format.
     */
    @JsonProperty(value = "timeStamp", required = true)
    private OffsetDateTime timestamp;

    /*
     * Predictive value in this time bucket.
     */
    @JsonProperty(value = "value", required = true)
    private double value;

    /** Creates an instance of PredictiveValue class. */
    public PredictiveValue() {
    }

    /**
     * Get the timestamp property: the timestamp for the metric value in ISO 8601 format.
     *
     * @return the timestamp value.
     */
    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    /**
     * Set the timestamp property: the timestamp for the metric value in ISO 8601 format.
     *
     * @param timestamp the timestamp value to set.
     * @return the PredictiveValue object itself.
     */
    public PredictiveValue withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    /**
     * Get the value property: Predictive value in this time bucket.
     *
     * @return the value value.
     */
    public double value() {
        return this.value;
    }

    /**
     * Set the value property: Predictive value in this time bucket.
     *
     * @param value the value value to set.
     * @return the PredictiveValue object itself.
     */
    public PredictiveValue withValue(double value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (timestamp() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property timestamp in model PredictiveValue"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(PredictiveValue.class);
}
