// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.monitor.fluent.models.MetricAlertPropertiesPatch;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

/** The metric alert resource for patch operations. */
@Fluent
public final class MetricAlertResourcePatch {
    /*
     * Resource tags
     */
    @JsonProperty(value = "tags")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;

    /*
     * The alert rule properties of the resource.
     */
    @JsonProperty(value = "properties")
    private MetricAlertPropertiesPatch innerProperties;

    /** Creates an instance of MetricAlertResourcePatch class. */
    public MetricAlertResourcePatch() {
    }

    /**
     * Get the tags property: Resource tags.
     *
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Resource tags.
     *
     * @param tags the tags value to set.
     * @return the MetricAlertResourcePatch object itself.
     */
    public MetricAlertResourcePatch withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the innerProperties property: The alert rule properties of the resource.
     *
     * @return the innerProperties value.
     */
    private MetricAlertPropertiesPatch innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the description property: the description of the metric alert that will be included in the alert email.
     *
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: the description of the metric alert that will be included in the alert email.
     *
     * @param description the description value to set.
     * @return the MetricAlertResourcePatch object itself.
     */
    public MetricAlertResourcePatch withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricAlertPropertiesPatch();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the severity property: Alert severity {0, 1, 2, 3, 4}.
     *
     * @return the severity value.
     */
    public Integer severity() {
        return this.innerProperties() == null ? null : this.innerProperties().severity();
    }

    /**
     * Set the severity property: Alert severity {0, 1, 2, 3, 4}.
     *
     * @param severity the severity value to set.
     * @return the MetricAlertResourcePatch object itself.
     */
    public MetricAlertResourcePatch withSeverity(Integer severity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricAlertPropertiesPatch();
        }
        this.innerProperties().withSeverity(severity);
        return this;
    }

    /**
     * Get the enabled property: the flag that indicates whether the metric alert is enabled.
     *
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().enabled();
    }

    /**
     * Set the enabled property: the flag that indicates whether the metric alert is enabled.
     *
     * @param enabled the enabled value to set.
     * @return the MetricAlertResourcePatch object itself.
     */
    public MetricAlertResourcePatch withEnabled(Boolean enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricAlertPropertiesPatch();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    /**
     * Get the scopes property: the list of resource id's that this metric alert is scoped to.
     *
     * @return the scopes value.
     */
    public List<String> scopes() {
        return this.innerProperties() == null ? null : this.innerProperties().scopes();
    }

    /**
     * Set the scopes property: the list of resource id's that this metric alert is scoped to.
     *
     * @param scopes the scopes value to set.
     * @return the MetricAlertResourcePatch object itself.
     */
    public MetricAlertResourcePatch withScopes(List<String> scopes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricAlertPropertiesPatch();
        }
        this.innerProperties().withScopes(scopes);
        return this;
    }

    /**
     * Get the evaluationFrequency property: how often the metric alert is evaluated represented in ISO 8601 duration
     * format.
     *
     * @return the evaluationFrequency value.
     */
    public Duration evaluationFrequency() {
        return this.innerProperties() == null ? null : this.innerProperties().evaluationFrequency();
    }

    /**
     * Set the evaluationFrequency property: how often the metric alert is evaluated represented in ISO 8601 duration
     * format.
     *
     * @param evaluationFrequency the evaluationFrequency value to set.
     * @return the MetricAlertResourcePatch object itself.
     */
    public MetricAlertResourcePatch withEvaluationFrequency(Duration evaluationFrequency) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricAlertPropertiesPatch();
        }
        this.innerProperties().withEvaluationFrequency(evaluationFrequency);
        return this;
    }

    /**
     * Get the windowSize property: the period of time (in ISO 8601 duration format) that is used to monitor alert
     * activity based on the threshold.
     *
     * @return the windowSize value.
     */
    public Duration windowSize() {
        return this.innerProperties() == null ? null : this.innerProperties().windowSize();
    }

    /**
     * Set the windowSize property: the period of time (in ISO 8601 duration format) that is used to monitor alert
     * activity based on the threshold.
     *
     * @param windowSize the windowSize value to set.
     * @return the MetricAlertResourcePatch object itself.
     */
    public MetricAlertResourcePatch withWindowSize(Duration windowSize) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricAlertPropertiesPatch();
        }
        this.innerProperties().withWindowSize(windowSize);
        return this;
    }

    /**
     * Get the targetResourceType property: the resource type of the target resource(s) on which the alert is
     * created/updated. Mandatory for MultipleResourceMultipleMetricCriteria.
     *
     * @return the targetResourceType value.
     */
    public String targetResourceType() {
        return this.innerProperties() == null ? null : this.innerProperties().targetResourceType();
    }

    /**
     * Set the targetResourceType property: the resource type of the target resource(s) on which the alert is
     * created/updated. Mandatory for MultipleResourceMultipleMetricCriteria.
     *
     * @param targetResourceType the targetResourceType value to set.
     * @return the MetricAlertResourcePatch object itself.
     */
    public MetricAlertResourcePatch withTargetResourceType(String targetResourceType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricAlertPropertiesPatch();
        }
        this.innerProperties().withTargetResourceType(targetResourceType);
        return this;
    }

    /**
     * Get the targetResourceRegion property: the region of the target resource(s) on which the alert is
     * created/updated. Mandatory for MultipleResourceMultipleMetricCriteria.
     *
     * @return the targetResourceRegion value.
     */
    public String targetResourceRegion() {
        return this.innerProperties() == null ? null : this.innerProperties().targetResourceRegion();
    }

    /**
     * Set the targetResourceRegion property: the region of the target resource(s) on which the alert is
     * created/updated. Mandatory for MultipleResourceMultipleMetricCriteria.
     *
     * @param targetResourceRegion the targetResourceRegion value to set.
     * @return the MetricAlertResourcePatch object itself.
     */
    public MetricAlertResourcePatch withTargetResourceRegion(String targetResourceRegion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricAlertPropertiesPatch();
        }
        this.innerProperties().withTargetResourceRegion(targetResourceRegion);
        return this;
    }

    /**
     * Get the criteria property: defines the specific alert criteria information.
     *
     * @return the criteria value.
     */
    public MetricAlertCriteria criteria() {
        return this.innerProperties() == null ? null : this.innerProperties().criteria();
    }

    /**
     * Set the criteria property: defines the specific alert criteria information.
     *
     * @param criteria the criteria value to set.
     * @return the MetricAlertResourcePatch object itself.
     */
    public MetricAlertResourcePatch withCriteria(MetricAlertCriteria criteria) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricAlertPropertiesPatch();
        }
        this.innerProperties().withCriteria(criteria);
        return this;
    }

    /**
     * Get the autoMitigate property: the flag that indicates whether the alert should be auto resolved or not. The
     * default is true.
     *
     * @return the autoMitigate value.
     */
    public Boolean autoMitigate() {
        return this.innerProperties() == null ? null : this.innerProperties().autoMitigate();
    }

    /**
     * Set the autoMitigate property: the flag that indicates whether the alert should be auto resolved or not. The
     * default is true.
     *
     * @param autoMitigate the autoMitigate value to set.
     * @return the MetricAlertResourcePatch object itself.
     */
    public MetricAlertResourcePatch withAutoMitigate(Boolean autoMitigate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricAlertPropertiesPatch();
        }
        this.innerProperties().withAutoMitigate(autoMitigate);
        return this;
    }

    /**
     * Get the actions property: the array of actions that are performed when the alert rule becomes active, and when an
     * alert condition is resolved.
     *
     * @return the actions value.
     */
    public List<MetricAlertAction> actions() {
        return this.innerProperties() == null ? null : this.innerProperties().actions();
    }

    /**
     * Set the actions property: the array of actions that are performed when the alert rule becomes active, and when an
     * alert condition is resolved.
     *
     * @param actions the actions value to set.
     * @return the MetricAlertResourcePatch object itself.
     */
    public MetricAlertResourcePatch withActions(List<MetricAlertAction> actions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricAlertPropertiesPatch();
        }
        this.innerProperties().withActions(actions);
        return this;
    }

    /**
     * Get the lastUpdatedTime property: Last time the rule was updated in ISO8601 format.
     *
     * @return the lastUpdatedTime value.
     */
    public OffsetDateTime lastUpdatedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastUpdatedTime();
    }

    /**
     * Get the isMigrated property: the value indicating whether this alert rule is migrated.
     *
     * @return the isMigrated value.
     */
    public Boolean isMigrated() {
        return this.innerProperties() == null ? null : this.innerProperties().isMigrated();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
