// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Indicates the type of scheduled query rule. The default is LogAlert. */
public final class Kind extends ExpandableStringEnum<Kind> {
    /** Static value LogAlert for Kind. */
    public static final Kind LOG_ALERT = fromString("LogAlert");

    /** Static value LogToMetric for Kind. */
    public static final Kind LOG_TO_METRIC = fromString("LogToMetric");

    /**
     * Creates or finds a Kind from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding Kind.
     */
    @JsonCreator
    public static Kind fromString(String name) {
        return fromString(name, Kind.class);
    }

    /**
     * Gets known Kind values.
     *
     * @return known Kind values.
     */
    public static Collection<Kind> values() {
        return values(Kind.class);
    }
}
