// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The action detail. */
@Fluent
public final class ActionDetail {
    /*
     * The mechanism type
     */
    @JsonProperty(value = "MechanismType")
    private String mechanismType;

    /*
     * The name of the action
     */
    @JsonProperty(value = "Name")
    private String name;

    /*
     * The status of the action
     */
    @JsonProperty(value = "Status")
    private String status;

    /*
     * The substatus of the action
     */
    @JsonProperty(value = "SubState")
    private String subState;

    /*
     * The send time
     */
    @JsonProperty(value = "SendTime")
    private String sendTime;

    /*
     * The detail of the friendly error message
     */
    @JsonProperty(value = "Detail")
    private String detail;

    /** Creates an instance of ActionDetail class. */
    public ActionDetail() {
    }

    /**
     * Get the mechanismType property: The mechanism type.
     *
     * @return the mechanismType value.
     */
    public String mechanismType() {
        return this.mechanismType;
    }

    /**
     * Set the mechanismType property: The mechanism type.
     *
     * @param mechanismType the mechanismType value to set.
     * @return the ActionDetail object itself.
     */
    public ActionDetail withMechanismType(String mechanismType) {
        this.mechanismType = mechanismType;
        return this;
    }

    /**
     * Get the name property: The name of the action.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the action.
     *
     * @param name the name value to set.
     * @return the ActionDetail object itself.
     */
    public ActionDetail withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the status property: The status of the action.
     *
     * @return the status value.
     */
    public String status() {
        return this.status;
    }

    /**
     * Set the status property: The status of the action.
     *
     * @param status the status value to set.
     * @return the ActionDetail object itself.
     */
    public ActionDetail withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
     * Get the subState property: The substatus of the action.
     *
     * @return the subState value.
     */
    public String subState() {
        return this.subState;
    }

    /**
     * Set the subState property: The substatus of the action.
     *
     * @param subState the subState value to set.
     * @return the ActionDetail object itself.
     */
    public ActionDetail withSubState(String subState) {
        this.subState = subState;
        return this;
    }

    /**
     * Get the sendTime property: The send time.
     *
     * @return the sendTime value.
     */
    public String sendTime() {
        return this.sendTime;
    }

    /**
     * Set the sendTime property: The send time.
     *
     * @param sendTime the sendTime value to set.
     * @return the ActionDetail object itself.
     */
    public ActionDetail withSendTime(String sendTime) {
        this.sendTime = sendTime;
        return this;
    }

    /**
     * Get the detail property: The detail of the friendly error message.
     *
     * @return the detail value.
     */
    public String detail() {
        return this.detail;
    }

    /**
     * Set the detail property: The detail of the friendly error message.
     *
     * @param detail the detail value to set.
     * @return the ActionDetail object itself.
     */
    public ActionDetail withDetail(String detail) {
        this.detail = detail;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
