// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.monitor.fluent.models.ActionGroupResourceInner;
import com.azure.resourcemanager.monitor.fluent.models.TestNotificationDetailsResponseInner;
import com.azure.resourcemanager.monitor.models.ActionGroupPatchBody;
import com.azure.resourcemanager.monitor.models.EnableRequest;
import com.azure.resourcemanager.monitor.models.NotificationRequestBody;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in ActionGroupsClient. */
public interface ActionGroupsClient
    extends InnerSupportsGet<ActionGroupResourceInner>,
        InnerSupportsListing<ActionGroupResourceInner>,
        InnerSupportsDelete<Void> {
    /**
     * Create a new action group or update an existing one.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param actionGroup The action group to create or use for the update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an action group resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ActionGroupResourceInner>> createOrUpdateWithResponseAsync(
        String resourceGroupName, String actionGroupName, ActionGroupResourceInner actionGroup);

    /**
     * Create a new action group or update an existing one.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param actionGroup The action group to create or use for the update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an action group resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ActionGroupResourceInner> createOrUpdateAsync(
        String resourceGroupName, String actionGroupName, ActionGroupResourceInner actionGroup);

    /**
     * Create a new action group or update an existing one.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param actionGroup The action group to create or use for the update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an action group resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ActionGroupResourceInner> createOrUpdateWithResponse(
        String resourceGroupName, String actionGroupName, ActionGroupResourceInner actionGroup, Context context);

    /**
     * Create a new action group or update an existing one.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param actionGroup The action group to create or use for the update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an action group resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ActionGroupResourceInner createOrUpdate(
        String resourceGroupName, String actionGroupName, ActionGroupResourceInner actionGroup);

    /**
     * Get an action group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an action group along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ActionGroupResourceInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String actionGroupName);

    /**
     * Get an action group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an action group on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ActionGroupResourceInner> getByResourceGroupAsync(String resourceGroupName, String actionGroupName);

    /**
     * Get an action group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an action group along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ActionGroupResourceInner> getByResourceGroupWithResponse(
        String resourceGroupName, String actionGroupName, Context context);

    /**
     * Get an action group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an action group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ActionGroupResourceInner getByResourceGroup(String resourceGroupName, String actionGroupName);

    /**
     * Delete an action group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String actionGroupName);

    /**
     * Delete an action group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String actionGroupName);

    /**
     * Delete an action group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String resourceGroupName, String actionGroupName, Context context);

    /**
     * Delete an action group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String actionGroupName);

    /**
     * Updates an existing action group's tags. To update other fields use the CreateOrUpdate method.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param actionGroupPatch Parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an action group resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ActionGroupResourceInner>> updateWithResponseAsync(
        String resourceGroupName, String actionGroupName, ActionGroupPatchBody actionGroupPatch);

    /**
     * Updates an existing action group's tags. To update other fields use the CreateOrUpdate method.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param actionGroupPatch Parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an action group resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ActionGroupResourceInner> updateAsync(
        String resourceGroupName, String actionGroupName, ActionGroupPatchBody actionGroupPatch);

    /**
     * Updates an existing action group's tags. To update other fields use the CreateOrUpdate method.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param actionGroupPatch Parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an action group resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ActionGroupResourceInner> updateWithResponse(
        String resourceGroupName, String actionGroupName, ActionGroupPatchBody actionGroupPatch, Context context);

    /**
     * Updates an existing action group's tags. To update other fields use the CreateOrUpdate method.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param actionGroupPatch Parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an action group resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ActionGroupResourceInner update(
        String resourceGroupName, String actionGroupName, ActionGroupPatchBody actionGroupPatch);

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> postTestNotificationsWithResponseAsync(
        NotificationRequestBody notificationRequest);

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner>
        beginPostTestNotificationsAsync(NotificationRequestBody notificationRequest);

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner>
        beginPostTestNotifications(NotificationRequestBody notificationRequest);

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param notificationRequest The notification request body which includes the contact details.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner>
        beginPostTestNotifications(NotificationRequestBody notificationRequest, Context context);

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<TestNotificationDetailsResponseInner> postTestNotificationsAsync(NotificationRequestBody notificationRequest);

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    TestNotificationDetailsResponseInner postTestNotifications(NotificationRequestBody notificationRequest);

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param notificationRequest The notification request body which includes the contact details.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    TestNotificationDetailsResponseInner postTestNotifications(
        NotificationRequestBody notificationRequest, Context context);

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createNotificationsAtResourceGroupLevelWithResponseAsync(
        String resourceGroupName, NotificationRequestBody notificationRequest);

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner>
        beginCreateNotificationsAtResourceGroupLevelAsync(
            String resourceGroupName, NotificationRequestBody notificationRequest);

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner>
        beginCreateNotificationsAtResourceGroupLevel(
            String resourceGroupName, NotificationRequestBody notificationRequest);

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param notificationRequest The notification request body which includes the contact details.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner>
        beginCreateNotificationsAtResourceGroupLevel(
            String resourceGroupName, NotificationRequestBody notificationRequest, Context context);

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<TestNotificationDetailsResponseInner> createNotificationsAtResourceGroupLevelAsync(
        String resourceGroupName, NotificationRequestBody notificationRequest);

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    TestNotificationDetailsResponseInner createNotificationsAtResourceGroupLevel(
        String resourceGroupName, NotificationRequestBody notificationRequest);

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param notificationRequest The notification request body which includes the contact details.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    TestNotificationDetailsResponseInner createNotificationsAtResourceGroupLevel(
        String resourceGroupName, NotificationRequestBody notificationRequest, Context context);

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createNotificationsAtActionGroupResourceLevelWithResponseAsync(
        String resourceGroupName, String actionGroupName, NotificationRequestBody notificationRequest);

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner>
        beginCreateNotificationsAtActionGroupResourceLevelAsync(
            String resourceGroupName, String actionGroupName, NotificationRequestBody notificationRequest);

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner>
        beginCreateNotificationsAtActionGroupResourceLevel(
            String resourceGroupName, String actionGroupName, NotificationRequestBody notificationRequest);

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param notificationRequest The notification request body which includes the contact details.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner>
        beginCreateNotificationsAtActionGroupResourceLevel(
            String resourceGroupName,
            String actionGroupName,
            NotificationRequestBody notificationRequest,
            Context context);

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<TestNotificationDetailsResponseInner> createNotificationsAtActionGroupResourceLevelAsync(
        String resourceGroupName, String actionGroupName, NotificationRequestBody notificationRequest);

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    TestNotificationDetailsResponseInner createNotificationsAtActionGroupResourceLevel(
        String resourceGroupName, String actionGroupName, NotificationRequestBody notificationRequest);

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param notificationRequest The notification request body which includes the contact details.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    TestNotificationDetailsResponseInner createNotificationsAtActionGroupResourceLevel(
        String resourceGroupName, String actionGroupName, NotificationRequestBody notificationRequest, Context context);

    /**
     * Get the test notifications by the notification id.
     *
     * @param notificationId The notification id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the test notifications by the notification id along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<TestNotificationDetailsResponseInner>> getTestNotificationsWithResponseAsync(String notificationId);

    /**
     * Get the test notifications by the notification id.
     *
     * @param notificationId The notification id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the test notifications by the notification id on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<TestNotificationDetailsResponseInner> getTestNotificationsAsync(String notificationId);

    /**
     * Get the test notifications by the notification id.
     *
     * @param notificationId The notification id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the test notifications by the notification id along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<TestNotificationDetailsResponseInner> getTestNotificationsWithResponse(
        String notificationId, Context context);

    /**
     * Get the test notifications by the notification id.
     *
     * @param notificationId The notification id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the test notifications by the notification id.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    TestNotificationDetailsResponseInner getTestNotifications(String notificationId);

    /**
     * Get the test notifications by the notification id.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param notificationId The notification id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the test notifications by the notification id along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<TestNotificationDetailsResponseInner>> getTestNotificationsAtResourceGroupLevelWithResponseAsync(
        String resourceGroupName, String notificationId);

    /**
     * Get the test notifications by the notification id.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param notificationId The notification id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the test notifications by the notification id on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<TestNotificationDetailsResponseInner> getTestNotificationsAtResourceGroupLevelAsync(
        String resourceGroupName, String notificationId);

    /**
     * Get the test notifications by the notification id.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param notificationId The notification id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the test notifications by the notification id along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<TestNotificationDetailsResponseInner> getTestNotificationsAtResourceGroupLevelWithResponse(
        String resourceGroupName, String notificationId, Context context);

    /**
     * Get the test notifications by the notification id.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param notificationId The notification id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the test notifications by the notification id.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    TestNotificationDetailsResponseInner getTestNotificationsAtResourceGroupLevel(
        String resourceGroupName, String notificationId);

    /**
     * Get the test notifications by the notification id.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param notificationId The notification id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the test notifications by the notification id along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<TestNotificationDetailsResponseInner>>
        getTestNotificationsAtActionGroupResourceLevelWithResponseAsync(
            String resourceGroupName, String actionGroupName, String notificationId);

    /**
     * Get the test notifications by the notification id.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param notificationId The notification id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the test notifications by the notification id on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<TestNotificationDetailsResponseInner> getTestNotificationsAtActionGroupResourceLevelAsync(
        String resourceGroupName, String actionGroupName, String notificationId);

    /**
     * Get the test notifications by the notification id.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param notificationId The notification id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the test notifications by the notification id along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<TestNotificationDetailsResponseInner> getTestNotificationsAtActionGroupResourceLevelWithResponse(
        String resourceGroupName, String actionGroupName, String notificationId, Context context);

    /**
     * Get the test notifications by the notification id.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param notificationId The notification id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the test notifications by the notification id.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    TestNotificationDetailsResponseInner getTestNotificationsAtActionGroupResourceLevel(
        String resourceGroupName, String actionGroupName, String notificationId);

    /**
     * Get a list of all action groups in a subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all action groups in a subscription as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ActionGroupResourceInner> listAsync();

    /**
     * Get a list of all action groups in a subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all action groups in a subscription as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ActionGroupResourceInner> list();

    /**
     * Get a list of all action groups in a subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all action groups in a subscription as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ActionGroupResourceInner> list(Context context);

    /**
     * Get a list of all action groups in a resource group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all action groups in a resource group as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ActionGroupResourceInner> listByResourceGroupAsync(String resourceGroupName);

    /**
     * Get a list of all action groups in a resource group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all action groups in a resource group as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ActionGroupResourceInner> listByResourceGroup(String resourceGroupName);

    /**
     * Get a list of all action groups in a resource group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all action groups in a resource group as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ActionGroupResourceInner> listByResourceGroup(String resourceGroupName, Context context);

    /**
     * Enable a receiver in an action group. This changes the receiver's status from Disabled to Enabled. This operation
     * is only supported for Email or SMS receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param enableRequest The receiver to re-enable.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> enableReceiverWithResponseAsync(
        String resourceGroupName, String actionGroupName, EnableRequest enableRequest);

    /**
     * Enable a receiver in an action group. This changes the receiver's status from Disabled to Enabled. This operation
     * is only supported for Email or SMS receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param enableRequest The receiver to re-enable.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> enableReceiverAsync(String resourceGroupName, String actionGroupName, EnableRequest enableRequest);

    /**
     * Enable a receiver in an action group. This changes the receiver's status from Disabled to Enabled. This operation
     * is only supported for Email or SMS receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param enableRequest The receiver to re-enable.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> enableReceiverWithResponse(
        String resourceGroupName, String actionGroupName, EnableRequest enableRequest, Context context);

    /**
     * Enable a receiver in an action group. This changes the receiver's status from Disabled to Enabled. This operation
     * is only supported for Email or SMS receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param enableRequest The receiver to re-enable.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void enableReceiver(String resourceGroupName, String actionGroupName, EnableRequest enableRequest);
}
