/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.fluent.models.AutoscaleProfileInner;
import com.azure.resourcemanager.monitor.fluent.models.ScaleRuleInner;
import com.azure.resourcemanager.monitor.implementation.AutoscaleSettingImpl;
import com.azure.resourcemanager.monitor.implementation.ScaleRuleImpl;
import com.azure.resourcemanager.monitor.models.AutoscaleProfile;
import com.azure.resourcemanager.monitor.models.DayOfWeek;
import com.azure.resourcemanager.monitor.models.Recurrence;
import com.azure.resourcemanager.monitor.models.RecurrenceFrequency;
import com.azure.resourcemanager.monitor.models.RecurrentSchedule;
import com.azure.resourcemanager.monitor.models.ScaleCapacity;
import com.azure.resourcemanager.monitor.models.ScaleRule;
import com.azure.resourcemanager.monitor.models.TimeWindow;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.WrapperImpl;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;

class AutoscaleProfileImpl
extends WrapperImpl<AutoscaleProfileInner>
implements AutoscaleProfile,
AutoscaleProfile.Definition,
AutoscaleProfile.UpdateDefinition,
AutoscaleProfile.Update {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private final AutoscaleSettingImpl parent;

    AutoscaleProfileImpl(String name, AutoscaleProfileInner innerObject, AutoscaleSettingImpl parent) {
        super((Object)innerObject);
        ((AutoscaleProfileInner)this.innerModel()).withName(name);
        this.parent = parent;
        if (((AutoscaleProfileInner)this.innerModel()).capacity() == null) {
            ((AutoscaleProfileInner)this.innerModel()).withCapacity(new ScaleCapacity());
        }
        if (((AutoscaleProfileInner)this.innerModel()).rules() == null) {
            ((AutoscaleProfileInner)this.innerModel()).withRules(new ArrayList<ScaleRuleInner>());
        }
    }

    public String name() {
        return ((AutoscaleProfileInner)this.innerModel()).name();
    }

    @Override
    public int minInstanceCount() {
        if (((AutoscaleProfileInner)this.innerModel()).capacity() != null) {
            return Integer.parseInt(((AutoscaleProfileInner)this.innerModel()).capacity().minimum());
        }
        return 0;
    }

    @Override
    public int maxInstanceCount() {
        if (((AutoscaleProfileInner)this.innerModel()).capacity() != null) {
            return Integer.parseInt(((AutoscaleProfileInner)this.innerModel()).capacity().maximum());
        }
        return 0;
    }

    @Override
    public int defaultInstanceCount() {
        if (((AutoscaleProfileInner)this.innerModel()).capacity() != null) {
            return Integer.parseInt(((AutoscaleProfileInner)this.innerModel()).capacity().defaultProperty());
        }
        return 0;
    }

    @Override
    public TimeWindow fixedDateSchedule() {
        return ((AutoscaleProfileInner)this.innerModel()).fixedDate();
    }

    @Override
    public Recurrence recurrentSchedule() {
        return ((AutoscaleProfileInner)this.innerModel()).recurrence();
    }

    @Override
    public List<ScaleRule> rules() {
        ArrayList<ScaleRule> rules = new ArrayList<ScaleRule>();
        if (((AutoscaleProfileInner)this.innerModel()).rules() != null) {
            for (ScaleRuleInner ruleInner : ((AutoscaleProfileInner)this.innerModel()).rules()) {
                rules.add(new ScaleRuleImpl(ruleInner, this));
            }
        }
        return rules;
    }

    public AutoscaleSettingImpl parent() {
        return this.parent;
    }

    public AutoscaleSettingImpl attach() {
        return this.parent.addNewAutoscaleProfile(this);
    }

    @Override
    public AutoscaleProfileImpl withMetricBasedScale(int minimumInstanceCount, int maximumInstanceCount, int defaultInstanceCount) {
        ((AutoscaleProfileInner)this.innerModel()).capacity().withMinimum(Integer.toString(minimumInstanceCount));
        ((AutoscaleProfileInner)this.innerModel()).capacity().withMaximum(Integer.toString(maximumInstanceCount));
        ((AutoscaleProfileInner)this.innerModel()).capacity().withDefaultProperty(Integer.toString(defaultInstanceCount));
        return this;
    }

    @Override
    public AutoscaleProfileImpl withScheduleBasedScale(int instanceCount) {
        return this.withMetricBasedScale(instanceCount, instanceCount, instanceCount);
    }

    @Override
    public AutoscaleProfileImpl withFixedInstanceCount(int instanceCount) {
        this.withMetricBasedScale(instanceCount, instanceCount, instanceCount);
        ((AutoscaleProfileInner)this.innerModel()).withFixedDate(null);
        ((AutoscaleProfileInner)this.innerModel()).withRecurrence(null);
        ((AutoscaleProfileInner)this.innerModel()).withRules(new ArrayList<ScaleRuleInner>());
        return this;
    }

    @Override
    public AutoscaleProfileImpl withFixedDateSchedule(String timeZone, OffsetDateTime start, OffsetDateTime end) {
        ((AutoscaleProfileInner)this.innerModel()).withFixedDate(new TimeWindow().withTimeZone(timeZone).withStart(start).withEnd(end));
        if (((AutoscaleProfileInner)this.innerModel()).recurrence() != null) {
            ((AutoscaleProfileInner)this.innerModel()).withRecurrence(null);
        }
        return this;
    }

    @Override
    public AutoscaleProfileImpl withRecurrentSchedule(String scheduleTimeZone, String startTime, DayOfWeek ... weekday) {
        if (!(startTime != null && !startTime.isEmpty() && startTime.length() == 5 && startTime.charAt(2) == ':' && Character.isDigit(startTime.charAt(0)) && Character.isDigit(startTime.charAt(1)) && Character.isDigit(startTime.charAt(3)) && Character.isDigit(startTime.charAt(4)))) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Start time should have format of 'hh:mm' where hh is in 24-hour clock (AM/PM times are not supported)."));
        }
        int hh = Integer.parseInt(startTime.substring(0, 2));
        int mm = Integer.parseInt(startTime.substring(3));
        if (hh > 23 || mm > 60) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Start time should have format of 'hh:mm' where hh is in 24-hour clock (AM/PM times are not supported)."));
        }
        ((AutoscaleProfileInner)this.innerModel()).withRecurrence(new Recurrence());
        ((AutoscaleProfileInner)this.innerModel()).recurrence().withFrequency(RecurrenceFrequency.WEEK);
        ((AutoscaleProfileInner)this.innerModel()).recurrence().withSchedule(new RecurrentSchedule());
        ((AutoscaleProfileInner)this.innerModel()).recurrence().schedule().withTimeZone(scheduleTimeZone);
        ((AutoscaleProfileInner)this.innerModel()).recurrence().schedule().withHours(new ArrayList<Integer>());
        ((AutoscaleProfileInner)this.innerModel()).recurrence().schedule().withMinutes(new ArrayList<Integer>());
        ((AutoscaleProfileInner)this.innerModel()).recurrence().schedule().hours().add(hh);
        ((AutoscaleProfileInner)this.innerModel()).recurrence().schedule().minutes().add(mm);
        ((AutoscaleProfileInner)this.innerModel()).recurrence().schedule().withDays(new ArrayList<String>());
        for (DayOfWeek dof : weekday) {
            ((AutoscaleProfileInner)this.innerModel()).recurrence().schedule().days().add(dof.toString());
        }
        ((AutoscaleProfileInner)this.innerModel()).withFixedDate(null);
        return this;
    }

    @Override
    public ScaleRuleImpl defineScaleRule() {
        return new ScaleRuleImpl(new ScaleRuleInner(), this);
    }

    @Override
    public ScaleRuleImpl updateScaleRule(int ruleIndex) {
        ScaleRuleImpl srToUpdate = new ScaleRuleImpl(((AutoscaleProfileInner)this.innerModel()).rules().get(ruleIndex), this);
        return srToUpdate;
    }

    @Override
    public AutoscaleProfileImpl withoutScaleRule(int ruleIndex) {
        ((AutoscaleProfileInner)this.innerModel()).rules().remove(ruleIndex);
        return this;
    }

    AutoscaleProfileImpl addNewScaleRule(ScaleRuleImpl scaleRule) {
        ((AutoscaleProfileInner)this.innerModel()).rules().add((ScaleRuleInner)scaleRule.innerModel());
        return this;
    }
}

