/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.AggregationTypeEnum;
import com.azure.resourcemanager.monitor.models.MetricDimension;
import com.azure.resourcemanager.monitor.models.MultiMetricCriteria;
import com.azure.resourcemanager.monitor.models.Operator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="criterionType")
@JsonTypeName(value="StaticThresholdCriterion")
public final class MetricCriteria
extends MultiMetricCriteria {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(MetricCriteria.class);
    @JsonProperty(value="operator", required=true)
    private Operator operator;
    @JsonProperty(value="threshold", required=true)
    private double threshold;

    public Operator operator() {
        return this.operator;
    }

    public MetricCriteria withOperator(Operator operator) {
        this.operator = operator;
        return this;
    }

    public double threshold() {
        return this.threshold;
    }

    public MetricCriteria withThreshold(double threshold) {
        this.threshold = threshold;
        return this;
    }

    @Override
    public MetricCriteria withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public MetricCriteria withMetricName(String metricName) {
        super.withMetricName(metricName);
        return this;
    }

    @Override
    public MetricCriteria withMetricNamespace(String metricNamespace) {
        super.withMetricNamespace(metricNamespace);
        return this;
    }

    @Override
    public MetricCriteria withTimeAggregation(AggregationTypeEnum timeAggregation) {
        super.withTimeAggregation(timeAggregation);
        return this;
    }

    @Override
    public MetricCriteria withDimensions(List<MetricDimension> dimensions) {
        super.withDimensions(dimensions);
        return this;
    }

    @Override
    public MetricCriteria withSkipMetricValidation(Boolean skipMetricValidation) {
        super.withSkipMetricValidation(skipMetricValidation);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.operator() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property operator in model MetricCriteria"));
        }
    }
}

