// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The resource management error response. */
@Immutable
public final class ErrorResponseCommon extends ManagementError {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ErrorResponseCommon.class);

    /*
     * The error details.
     */
    @JsonProperty(value = "details", access = JsonProperty.Access.WRITE_ONLY)
    private List<ErrorResponseCommon> details;

    /**
     * Get the details property: The error details.
     *
     * @return the details value.
     */
    public List<ErrorResponseCommon> getDetails() {
        return this.details;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (getDetails() != null) {
            getDetails().forEach(e -> e.validate());
        }
    }
}
