// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Email notification of an autoscale event. */
@Fluent
public final class EmailNotification {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(EmailNotification.class);

    /*
     * a value indicating whether to send email to subscription administrator.
     */
    @JsonProperty(value = "sendToSubscriptionAdministrator")
    private Boolean sendToSubscriptionAdministrator;

    /*
     * a value indicating whether to send email to subscription
     * co-administrators.
     */
    @JsonProperty(value = "sendToSubscriptionCoAdministrators")
    private Boolean sendToSubscriptionCoAdministrators;

    /*
     * the custom e-mails list. This value can be null or empty, in which case
     * this attribute will be ignored.
     */
    @JsonProperty(value = "customEmails")
    private List<String> customEmails;

    /**
     * Get the sendToSubscriptionAdministrator property: a value indicating whether to send email to subscription
     * administrator.
     *
     * @return the sendToSubscriptionAdministrator value.
     */
    public Boolean sendToSubscriptionAdministrator() {
        return this.sendToSubscriptionAdministrator;
    }

    /**
     * Set the sendToSubscriptionAdministrator property: a value indicating whether to send email to subscription
     * administrator.
     *
     * @param sendToSubscriptionAdministrator the sendToSubscriptionAdministrator value to set.
     * @return the EmailNotification object itself.
     */
    public EmailNotification withSendToSubscriptionAdministrator(Boolean sendToSubscriptionAdministrator) {
        this.sendToSubscriptionAdministrator = sendToSubscriptionAdministrator;
        return this;
    }

    /**
     * Get the sendToSubscriptionCoAdministrators property: a value indicating whether to send email to subscription
     * co-administrators.
     *
     * @return the sendToSubscriptionCoAdministrators value.
     */
    public Boolean sendToSubscriptionCoAdministrators() {
        return this.sendToSubscriptionCoAdministrators;
    }

    /**
     * Set the sendToSubscriptionCoAdministrators property: a value indicating whether to send email to subscription
     * co-administrators.
     *
     * @param sendToSubscriptionCoAdministrators the sendToSubscriptionCoAdministrators value to set.
     * @return the EmailNotification object itself.
     */
    public EmailNotification withSendToSubscriptionCoAdministrators(Boolean sendToSubscriptionCoAdministrators) {
        this.sendToSubscriptionCoAdministrators = sendToSubscriptionCoAdministrators;
        return this;
    }

    /**
     * Get the customEmails property: the custom e-mails list. This value can be null or empty, in which case this
     * attribute will be ignored.
     *
     * @return the customEmails value.
     */
    public List<String> customEmails() {
        return this.customEmails;
    }

    /**
     * Set the customEmails property: the custom e-mails list. This value can be null or empty, in which case this
     * attribute will be ignored.
     *
     * @param customEmails the customEmails value to set.
     * @return the EmailNotification object itself.
     */
    public EmailNotification withCustomEmails(List<String> customEmails) {
        this.customEmails = customEmails;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
