// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.KnownDataCollectionRuleAssociationProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Definition of generic ARM proxy resource. */
@JsonFlatten
@Fluent
public class DataCollectionRuleAssociationProxyOnlyResourceInner extends ProxyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DataCollectionRuleAssociationProxyOnlyResourceInner.class);

    /*
     * Resource entity tag (ETag).
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /*
     * Metadata pertaining to creation and last modification of the resource.
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /*
     * Description of the association.
     */
    @JsonProperty(value = "properties.description")
    private String description;

    /*
     * The resource ID of the data collection rule that is to be associated.
     */
    @JsonProperty(value = "properties.dataCollectionRuleId")
    private String dataCollectionRuleId;

    /*
     * The resource ID of the data collection endpoint that is to be
     * associated.
     */
    @JsonProperty(value = "properties.dataCollectionEndpointId")
    private String dataCollectionEndpointId;

    /*
     * The resource provisioning state.
     */
    @JsonProperty(value = "properties.provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private KnownDataCollectionRuleAssociationProvisioningState provisioningState;

    /**
     * Get the etag property: Resource entity tag (ETag).
     *
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the systemData property: Metadata pertaining to creation and last modification of the resource.
     *
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the description property: Description of the association.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description of the association.
     *
     * @param description the description value to set.
     * @return the DataCollectionRuleAssociationProxyOnlyResourceInner object itself.
     */
    public DataCollectionRuleAssociationProxyOnlyResourceInner withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the dataCollectionRuleId property: The resource ID of the data collection rule that is to be associated.
     *
     * @return the dataCollectionRuleId value.
     */
    public String dataCollectionRuleId() {
        return this.dataCollectionRuleId;
    }

    /**
     * Set the dataCollectionRuleId property: The resource ID of the data collection rule that is to be associated.
     *
     * @param dataCollectionRuleId the dataCollectionRuleId value to set.
     * @return the DataCollectionRuleAssociationProxyOnlyResourceInner object itself.
     */
    public DataCollectionRuleAssociationProxyOnlyResourceInner withDataCollectionRuleId(String dataCollectionRuleId) {
        this.dataCollectionRuleId = dataCollectionRuleId;
        return this;
    }

    /**
     * Get the dataCollectionEndpointId property: The resource ID of the data collection endpoint that is to be
     * associated.
     *
     * @return the dataCollectionEndpointId value.
     */
    public String dataCollectionEndpointId() {
        return this.dataCollectionEndpointId;
    }

    /**
     * Set the dataCollectionEndpointId property: The resource ID of the data collection endpoint that is to be
     * associated.
     *
     * @param dataCollectionEndpointId the dataCollectionEndpointId value to set.
     * @return the DataCollectionRuleAssociationProxyOnlyResourceInner object itself.
     */
    public DataCollectionRuleAssociationProxyOnlyResourceInner withDataCollectionEndpointId(
        String dataCollectionEndpointId) {
        this.dataCollectionEndpointId = dataCollectionEndpointId;
        return this;
    }

    /**
     * Get the provisioningState property: The resource provisioning state.
     *
     * @return the provisioningState value.
     */
    public KnownDataCollectionRuleAssociationProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
