/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.fluent.models.MhsmPrivateLinkResourceProperties;
import com.azure.resourcemanager.keyvault.models.ManagedHsmResource;
import com.azure.resourcemanager.keyvault.models.ManagedHsmSku;
import com.azure.resourcemanager.keyvault.models.ManagedServiceIdentity;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class MhsmPrivateLinkResource
extends ManagedHsmResource {
    private MhsmPrivateLinkResourceProperties innerProperties;
    private ManagedServiceIdentity identity;
    private SystemData systemData;
    private Map<String, String> tags;
    private ManagedHsmSku sku;
    private String location;
    private String type;
    private String name;
    private String id;

    private MhsmPrivateLinkResource() {
    }

    private MhsmPrivateLinkResourceProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    @Override
    public SystemData systemData() {
        return this.systemData;
    }

    @Override
    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public ManagedHsmSku sku() {
        return this.sku;
    }

    @Override
    public String location() {
        return this.location;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    public String groupId() {
        return this.innerProperties() == null ? null : this.innerProperties().groupId();
    }

    public List<String> requiredMembers() {
        return this.innerProperties() == null ? null : this.innerProperties().requiredMembers();
    }

    public List<String> requiredZoneNames() {
        return this.innerProperties() == null ? null : this.innerProperties().requiredZoneNames();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static MhsmPrivateLinkResource fromJson(JsonReader jsonReader) throws IOException {
        return (MhsmPrivateLinkResource)jsonReader.readObject(reader -> {
            MhsmPrivateLinkResource deserializedMhsmPrivateLinkResource = new MhsmPrivateLinkResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMhsmPrivateLinkResource.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMhsmPrivateLinkResource.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMhsmPrivateLinkResource.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedMhsmPrivateLinkResource.location = reader.getString();
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedMhsmPrivateLinkResource.sku = ManagedHsmSku.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedMhsmPrivateLinkResource.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedMhsmPrivateLinkResource.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedMhsmPrivateLinkResource.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedMhsmPrivateLinkResource.innerProperties = MhsmPrivateLinkResourceProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMhsmPrivateLinkResource;
        });
    }
}

