/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.models.MhsmServiceTagRule;
import com.azure.resourcemanager.keyvault.models.MhsmVirtualNetworkRule;
import com.azure.resourcemanager.keyvault.models.MhsmipRule;
import com.azure.resourcemanager.keyvault.models.NetworkRuleAction;
import com.azure.resourcemanager.keyvault.models.NetworkRuleBypassOptions;
import java.io.IOException;
import java.util.List;

public final class MhsmNetworkRuleSet
implements JsonSerializable<MhsmNetworkRuleSet> {
    private NetworkRuleBypassOptions bypass;
    private NetworkRuleAction defaultAction;
    private List<MhsmipRule> ipRules;
    private List<MhsmServiceTagRule> serviceTags;
    private List<MhsmVirtualNetworkRule> virtualNetworkRules;

    public NetworkRuleBypassOptions bypass() {
        return this.bypass;
    }

    public MhsmNetworkRuleSet withBypass(NetworkRuleBypassOptions bypass) {
        this.bypass = bypass;
        return this;
    }

    public NetworkRuleAction defaultAction() {
        return this.defaultAction;
    }

    public MhsmNetworkRuleSet withDefaultAction(NetworkRuleAction defaultAction) {
        this.defaultAction = defaultAction;
        return this;
    }

    public List<MhsmipRule> ipRules() {
        return this.ipRules;
    }

    public MhsmNetworkRuleSet withIpRules(List<MhsmipRule> ipRules) {
        this.ipRules = ipRules;
        return this;
    }

    public List<MhsmServiceTagRule> serviceTags() {
        return this.serviceTags;
    }

    public MhsmNetworkRuleSet withServiceTags(List<MhsmServiceTagRule> serviceTags) {
        this.serviceTags = serviceTags;
        return this;
    }

    public List<MhsmVirtualNetworkRule> virtualNetworkRules() {
        return this.virtualNetworkRules;
    }

    public MhsmNetworkRuleSet withVirtualNetworkRules(List<MhsmVirtualNetworkRule> virtualNetworkRules) {
        this.virtualNetworkRules = virtualNetworkRules;
        return this;
    }

    public void validate() {
        if (this.ipRules() != null) {
            this.ipRules().forEach(e -> e.validate());
        }
        if (this.serviceTags() != null) {
            this.serviceTags().forEach(e -> e.validate());
        }
        if (this.virtualNetworkRules() != null) {
            this.virtualNetworkRules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("bypass", this.bypass == null ? null : this.bypass.toString());
        jsonWriter.writeStringField("defaultAction", this.defaultAction == null ? null : this.defaultAction.toString());
        jsonWriter.writeArrayField("ipRules", this.ipRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("serviceTags", this.serviceTags, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("virtualNetworkRules", this.virtualNetworkRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static MhsmNetworkRuleSet fromJson(JsonReader jsonReader) throws IOException {
        return (MhsmNetworkRuleSet)jsonReader.readObject(reader -> {
            MhsmNetworkRuleSet deserializedMhsmNetworkRuleSet = new MhsmNetworkRuleSet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("bypass".equals(fieldName)) {
                    deserializedMhsmNetworkRuleSet.bypass = NetworkRuleBypassOptions.fromString(reader.getString());
                    continue;
                }
                if ("defaultAction".equals(fieldName)) {
                    deserializedMhsmNetworkRuleSet.defaultAction = NetworkRuleAction.fromString(reader.getString());
                    continue;
                }
                if ("ipRules".equals(fieldName)) {
                    List ipRules;
                    deserializedMhsmNetworkRuleSet.ipRules = ipRules = reader.readArray(reader1 -> MhsmipRule.fromJson(reader1));
                    continue;
                }
                if ("serviceTags".equals(fieldName)) {
                    List serviceTags;
                    deserializedMhsmNetworkRuleSet.serviceTags = serviceTags = reader.readArray(reader1 -> MhsmServiceTagRule.fromJson(reader1));
                    continue;
                }
                if ("virtualNetworkRules".equals(fieldName)) {
                    List virtualNetworkRules;
                    deserializedMhsmNetworkRuleSet.virtualNetworkRules = virtualNetworkRules = reader.readArray(reader1 -> MhsmVirtualNetworkRule.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMhsmNetworkRuleSet;
        });
    }
}

