/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.models.DeletionRecoveryLevel;
import java.io.IOException;

public final class KeyAttributes
implements JsonSerializable<KeyAttributes> {
    private Boolean enabled;
    private Long notBefore;
    private Long expires;
    private Long created;
    private Long updated;
    private DeletionRecoveryLevel recoveryLevel;
    private Boolean exportable;

    public Boolean enabled() {
        return this.enabled;
    }

    public KeyAttributes withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Long notBefore() {
        return this.notBefore;
    }

    public KeyAttributes withNotBefore(Long notBefore) {
        this.notBefore = notBefore;
        return this;
    }

    public Long expires() {
        return this.expires;
    }

    public KeyAttributes withExpires(Long expires) {
        this.expires = expires;
        return this;
    }

    public Long created() {
        return this.created;
    }

    public Long updated() {
        return this.updated;
    }

    public DeletionRecoveryLevel recoveryLevel() {
        return this.recoveryLevel;
    }

    public Boolean exportable() {
        return this.exportable;
    }

    public KeyAttributes withExportable(Boolean exportable) {
        this.exportable = exportable;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeNumberField("nbf", (Number)this.notBefore);
        jsonWriter.writeNumberField("exp", (Number)this.expires);
        jsonWriter.writeBooleanField("exportable", this.exportable);
        return jsonWriter.writeEndObject();
    }

    public static KeyAttributes fromJson(JsonReader jsonReader) throws IOException {
        return (KeyAttributes)jsonReader.readObject(reader -> {
            KeyAttributes deserializedKeyAttributes = new KeyAttributes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedKeyAttributes.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("nbf".equals(fieldName)) {
                    deserializedKeyAttributes.notBefore = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("exp".equals(fieldName)) {
                    deserializedKeyAttributes.expires = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("created".equals(fieldName)) {
                    deserializedKeyAttributes.created = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("updated".equals(fieldName)) {
                    deserializedKeyAttributes.updated = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("recoveryLevel".equals(fieldName)) {
                    deserializedKeyAttributes.recoveryLevel = DeletionRecoveryLevel.fromString(reader.getString());
                    continue;
                }
                if ("exportable".equals(fieldName)) {
                    deserializedKeyAttributes.exportable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyAttributes;
        });
    }
}

