/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.fluent.models.MhsmPrivateEndpointConnectionInner;
import java.io.IOException;
import java.util.List;

public final class MHSMPrivateEndpointConnectionsListResult
implements JsonSerializable<MHSMPrivateEndpointConnectionsListResult> {
    private List<MhsmPrivateEndpointConnectionInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(MHSMPrivateEndpointConnectionsListResult.class);

    private MHSMPrivateEndpointConnectionsListResult() {
    }

    public List<MhsmPrivateEndpointConnectionInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model MHSMPrivateEndpointConnectionsListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static MHSMPrivateEndpointConnectionsListResult fromJson(JsonReader jsonReader) throws IOException {
        return (MHSMPrivateEndpointConnectionsListResult)jsonReader.readObject(reader -> {
            MHSMPrivateEndpointConnectionsListResult deserializedMHSMPrivateEndpointConnectionsListResult = new MHSMPrivateEndpointConnectionsListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedMHSMPrivateEndpointConnectionsListResult.value = value = reader.readArray(reader1 -> MhsmPrivateEndpointConnectionInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedMHSMPrivateEndpointConnectionsListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMHSMPrivateEndpointConnectionsListResult;
        });
    }
}

