/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.keyvault.fluent.SecretsClient;
import com.azure.resourcemanager.keyvault.fluent.models.SecretInner;
import com.azure.resourcemanager.keyvault.implementation.KeyVaultManagementClientImpl;
import com.azure.resourcemanager.keyvault.implementation.models.SecretListResult;
import com.azure.resourcemanager.keyvault.models.SecretCreateOrUpdateParameters;
import com.azure.resourcemanager.keyvault.models.SecretPatchParameters;
import reactor.core.publisher.Mono;

public final class SecretsClientImpl
implements SecretsClient {
    private final SecretsService service;
    private final KeyVaultManagementClientImpl client;

    SecretsClientImpl(KeyVaultManagementClientImpl client) {
        this.service = (SecretsService)RestProxy.create(SecretsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SecretInner>> getWithResponseAsync(String resourceGroupName, String vaultName, String secretName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (secretName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter secretName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, vaultName, secretName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SecretInner>> getWithResponseAsync(String resourceGroupName, String vaultName, String secretName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (secretName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter secretName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, vaultName, secretName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SecretInner> getAsync(String resourceGroupName, String vaultName, String secretName) {
        return this.getWithResponseAsync(resourceGroupName, vaultName, secretName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SecretInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SecretInner> getWithResponse(String resourceGroupName, String vaultName, String secretName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, vaultName, secretName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SecretInner get(String resourceGroupName, String vaultName, String secretName) {
        return (SecretInner)((Object)this.getWithResponse(resourceGroupName, vaultName, secretName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SecretInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String vaultName, String secretName, SecretCreateOrUpdateParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (secretName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter secretName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, vaultName, secretName, "application/json", "application/json", parameters, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SecretInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String vaultName, String secretName, SecretCreateOrUpdateParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (secretName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter secretName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String contentType = "application/json";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, vaultName, secretName, "application/json", "application/json", parameters, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SecretInner> createOrUpdateAsync(String resourceGroupName, String vaultName, String secretName, SecretCreateOrUpdateParameters parameters) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, vaultName, secretName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SecretInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SecretInner> createOrUpdateWithResponse(String resourceGroupName, String vaultName, String secretName, SecretCreateOrUpdateParameters parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, vaultName, secretName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SecretInner createOrUpdate(String resourceGroupName, String vaultName, String secretName, SecretCreateOrUpdateParameters parameters) {
        return (SecretInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, vaultName, secretName, parameters, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SecretInner>> updateWithResponseAsync(String resourceGroupName, String vaultName, String secretName, SecretPatchParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (secretName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter secretName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, vaultName, secretName, "application/json", "application/json", parameters, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SecretInner>> updateWithResponseAsync(String resourceGroupName, String vaultName, String secretName, SecretPatchParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (secretName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter secretName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String contentType = "application/json";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, vaultName, secretName, "application/json", "application/json", parameters, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SecretInner> updateAsync(String resourceGroupName, String vaultName, String secretName, SecretPatchParameters parameters) {
        return this.updateWithResponseAsync(resourceGroupName, vaultName, secretName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SecretInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SecretInner> updateWithResponse(String resourceGroupName, String vaultName, String secretName, SecretPatchParameters parameters, Context context) {
        return (Response)this.updateWithResponseAsync(resourceGroupName, vaultName, secretName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SecretInner update(String resourceGroupName, String vaultName, String secretName, SecretPatchParameters parameters) {
        return (SecretInner)((Object)this.updateWithResponse(resourceGroupName, vaultName, secretName, parameters, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SecretInner>> listSinglePageAsync(String resourceGroupName, String vaultName, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, vaultName, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecretListResult)res.getValue()).value(), ((SecretListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SecretInner>> listSinglePageAsync(String resourceGroupName, String vaultName, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, vaultName, top, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecretListResult)res.getValue()).value(), ((SecretListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SecretInner> listAsync(String resourceGroupName, String vaultName, Integer top) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, vaultName, top), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SecretInner> listAsync(String resourceGroupName, String vaultName) {
        Integer top = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, vaultName, top), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SecretInner> listAsync(String resourceGroupName, String vaultName, Integer top, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, vaultName, top, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecretInner> list(String resourceGroupName, String vaultName) {
        Integer top = null;
        return new PagedIterable(this.listAsync(resourceGroupName, vaultName, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecretInner> list(String resourceGroupName, String vaultName, Integer top, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, vaultName, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SecretInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecretListResult)res.getValue()).value(), ((SecretListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SecretInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecretListResult)res.getValue()).value(), ((SecretListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="KeyVaultManagementClientSecrets")
    public static interface SecretsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/secrets/{secretName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecretInner>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="vaultName") String var5, @PathParam(value="secretName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/secrets/{secretName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecretInner>> createOrUpdate(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="vaultName") String var5, @PathParam(value="secretName") String var6, @HeaderParam(value="Content-Type") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") SecretCreateOrUpdateParameters var9, Context var10);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/secrets/{secretName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecretInner>> update(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="vaultName") String var5, @PathParam(value="secretName") String var6, @HeaderParam(value="Content-Type") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") SecretPatchParameters var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/secrets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecretListResult>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="vaultName") String var5, @QueryParam(value="$top") Integer var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecretListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

