/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.keyvault.fluent.KeyVaultManagementClient;
import com.azure.resourcemanager.keyvault.fluent.KeysClient;
import com.azure.resourcemanager.keyvault.fluent.ManagedHsmKeysClient;
import com.azure.resourcemanager.keyvault.fluent.ManagedHsmsClient;
import com.azure.resourcemanager.keyvault.fluent.MhsmPrivateEndpointConnectionsClient;
import com.azure.resourcemanager.keyvault.fluent.MhsmPrivateLinkResourcesClient;
import com.azure.resourcemanager.keyvault.fluent.MhsmRegionsClient;
import com.azure.resourcemanager.keyvault.fluent.OperationsClient;
import com.azure.resourcemanager.keyvault.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.keyvault.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.keyvault.fluent.SecretsClient;
import com.azure.resourcemanager.keyvault.fluent.VaultsClient;
import com.azure.resourcemanager.keyvault.implementation.KeyVaultManagementClientBuilder;
import com.azure.resourcemanager.keyvault.implementation.KeysClientImpl;
import com.azure.resourcemanager.keyvault.implementation.ManagedHsmKeysClientImpl;
import com.azure.resourcemanager.keyvault.implementation.ManagedHsmsClientImpl;
import com.azure.resourcemanager.keyvault.implementation.MhsmPrivateEndpointConnectionsClientImpl;
import com.azure.resourcemanager.keyvault.implementation.MhsmPrivateLinkResourcesClientImpl;
import com.azure.resourcemanager.keyvault.implementation.MhsmRegionsClientImpl;
import com.azure.resourcemanager.keyvault.implementation.OperationsClientImpl;
import com.azure.resourcemanager.keyvault.implementation.PrivateEndpointConnectionsClientImpl;
import com.azure.resourcemanager.keyvault.implementation.PrivateLinkResourcesClientImpl;
import com.azure.resourcemanager.keyvault.implementation.SecretsClientImpl;
import com.azure.resourcemanager.keyvault.implementation.VaultsClientImpl;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import java.time.Duration;

@ServiceClient(builder=KeyVaultManagementClientBuilder.class)
public final class KeyVaultManagementClientImpl
extends AzureServiceClient
implements KeyVaultManagementClient {
    private final String endpoint;
    private final String apiVersion;
    private final String subscriptionId;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final OperationsClient operations;
    private final VaultsClient vaults;
    private final PrivateEndpointConnectionsClient privateEndpointConnections;
    private final ManagedHsmsClient managedHsms;
    private final MhsmPrivateEndpointConnectionsClient mhsmPrivateEndpointConnections;
    private final SecretsClient secrets;
    private final KeysClient keys;
    private final ManagedHsmKeysClient managedHsmKeys;
    private final PrivateLinkResourcesClient privateLinkResources;
    private final MhsmPrivateLinkResourcesClient mhsmPrivateLinkResources;
    private final MhsmRegionsClient mhsmRegions;

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public VaultsClient getVaults() {
        return this.vaults;
    }

    @Override
    public PrivateEndpointConnectionsClient getPrivateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    @Override
    public ManagedHsmsClient getManagedHsms() {
        return this.managedHsms;
    }

    @Override
    public MhsmPrivateEndpointConnectionsClient getMhsmPrivateEndpointConnections() {
        return this.mhsmPrivateEndpointConnections;
    }

    @Override
    public SecretsClient getSecrets() {
        return this.secrets;
    }

    @Override
    public KeysClient getKeys() {
        return this.keys;
    }

    @Override
    public ManagedHsmKeysClient getManagedHsmKeys() {
        return this.managedHsmKeys;
    }

    @Override
    public PrivateLinkResourcesClient getPrivateLinkResources() {
        return this.privateLinkResources;
    }

    @Override
    public MhsmPrivateLinkResourcesClient getMhsmPrivateLinkResources() {
        return this.mhsmPrivateLinkResources;
    }

    @Override
    public MhsmRegionsClient getMhsmRegions() {
        return this.mhsmRegions;
    }

    KeyVaultManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String endpoint, String subscriptionId) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.endpoint = endpoint;
        this.subscriptionId = subscriptionId;
        this.apiVersion = "2025-05-01";
        this.operations = new OperationsClientImpl(this);
        this.vaults = new VaultsClientImpl(this);
        this.privateEndpointConnections = new PrivateEndpointConnectionsClientImpl(this);
        this.managedHsms = new ManagedHsmsClientImpl(this);
        this.mhsmPrivateEndpointConnections = new MhsmPrivateEndpointConnectionsClientImpl(this);
        this.secrets = new SecretsClientImpl(this);
        this.keys = new KeysClientImpl(this);
        this.managedHsmKeys = new ManagedHsmKeysClientImpl(this);
        this.privateLinkResources = new PrivateLinkResourcesClientImpl(this);
        this.mhsmPrivateLinkResources = new MhsmPrivateLinkResourcesClientImpl(this);
        this.mhsmRegions = new MhsmRegionsClientImpl(this);
    }
}

