/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.models.VaultAccessPolicyProperties;
import java.io.IOException;

public final class VaultAccessPolicyParametersInner
implements JsonSerializable<VaultAccessPolicyParametersInner> {
    private String id;
    private String name;
    private String type;
    private String location;
    private VaultAccessPolicyProperties properties;
    private static final ClientLogger LOGGER = new ClientLogger(VaultAccessPolicyParametersInner.class);

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String location() {
        return this.location;
    }

    public VaultAccessPolicyProperties properties() {
        return this.properties;
    }

    public VaultAccessPolicyParametersInner withProperties(VaultAccessPolicyProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model VaultAccessPolicyParametersInner"));
        }
        this.properties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static VaultAccessPolicyParametersInner fromJson(JsonReader jsonReader) throws IOException {
        return (VaultAccessPolicyParametersInner)jsonReader.readObject(reader -> {
            VaultAccessPolicyParametersInner deserializedVaultAccessPolicyParametersInner = new VaultAccessPolicyParametersInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedVaultAccessPolicyParametersInner.properties = VaultAccessPolicyProperties.fromJson(reader);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedVaultAccessPolicyParametersInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVaultAccessPolicyParametersInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVaultAccessPolicyParametersInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedVaultAccessPolicyParametersInner.location = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVaultAccessPolicyParametersInner;
        });
    }
}

