/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.fluent.models.MhsmPrivateEndpointConnectionProperties;
import com.azure.resourcemanager.keyvault.models.ManagedHsmSku;
import com.azure.resourcemanager.keyvault.models.ManagedServiceIdentity;
import com.azure.resourcemanager.keyvault.models.MhsmPrivateEndpoint;
import com.azure.resourcemanager.keyvault.models.MhsmPrivateLinkServiceConnectionState;
import com.azure.resourcemanager.keyvault.models.PrivateEndpointConnectionProvisioningState;
import java.io.IOException;
import java.util.Map;

public final class MhsmPrivateEndpointConnectionInner
extends ProxyResource {
    private MhsmPrivateEndpointConnectionProperties innerProperties;
    private Map<String, String> tags;
    private String location;
    private ManagedHsmSku sku;
    private ManagedServiceIdentity identity;
    private String etag;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private MhsmPrivateEndpointConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public MhsmPrivateEndpointConnectionInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String location() {
        return this.location;
    }

    public MhsmPrivateEndpointConnectionInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public ManagedHsmSku sku() {
        return this.sku;
    }

    public MhsmPrivateEndpointConnectionInner withSku(ManagedHsmSku sku) {
        this.sku = sku;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public MhsmPrivateEndpointConnectionInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public MhsmPrivateEndpointConnectionInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public MhsmPrivateEndpoint privateEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpoint();
    }

    public MhsmPrivateEndpointConnectionInner withPrivateEndpoint(MhsmPrivateEndpoint privateEndpoint) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MhsmPrivateEndpointConnectionProperties();
        }
        this.innerProperties().withPrivateEndpoint(privateEndpoint);
        return this;
    }

    public MhsmPrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkServiceConnectionState();
    }

    public MhsmPrivateEndpointConnectionInner withPrivateLinkServiceConnectionState(MhsmPrivateLinkServiceConnectionState privateLinkServiceConnectionState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MhsmPrivateEndpointConnectionProperties();
        }
        this.innerProperties().withPrivateLinkServiceConnectionState(privateLinkServiceConnectionState);
        return this;
    }

    public PrivateEndpointConnectionProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeStringField("etag", this.etag);
        return jsonWriter.writeEndObject();
    }

    public static MhsmPrivateEndpointConnectionInner fromJson(JsonReader jsonReader) throws IOException {
        return (MhsmPrivateEndpointConnectionInner)((Object)jsonReader.readObject(reader -> {
            MhsmPrivateEndpointConnectionInner deserializedMhsmPrivateEndpointConnectionInner = new MhsmPrivateEndpointConnectionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMhsmPrivateEndpointConnectionInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMhsmPrivateEndpointConnectionInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMhsmPrivateEndpointConnectionInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedMhsmPrivateEndpointConnectionInner.innerProperties = MhsmPrivateEndpointConnectionProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedMhsmPrivateEndpointConnectionInner.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedMhsmPrivateEndpointConnectionInner.location = reader.getString();
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedMhsmPrivateEndpointConnectionInner.sku = ManagedHsmSku.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedMhsmPrivateEndpointConnectionInner.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedMhsmPrivateEndpointConnectionInner.etag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedMhsmPrivateEndpointConnectionInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMhsmPrivateEndpointConnectionInner;
        }));
    }
}

