/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.models.ManagedHsmProperties;
import com.azure.resourcemanager.keyvault.models.ManagedHsmSku;
import com.azure.resourcemanager.keyvault.models.ManagedServiceIdentity;
import java.io.IOException;
import java.util.Map;

public final class ManagedHsmInner
extends Resource {
    private ManagedHsmProperties properties;
    private Map<String, String> tags;
    private String location;
    private ManagedHsmSku sku;
    private ManagedServiceIdentity identity;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public ManagedHsmProperties properties() {
        return this.properties;
    }

    public ManagedHsmInner withProperties(ManagedHsmProperties properties) {
        this.properties = properties;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ManagedHsmInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String location() {
        return this.location;
    }

    public ManagedHsmInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public ManagedHsmSku sku() {
        return this.sku;
    }

    public ManagedHsmInner withSku(ManagedHsmSku sku) {
        this.sku = sku;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public ManagedHsmInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static ManagedHsmInner fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedHsmInner)((Object)jsonReader.readObject(reader -> {
            ManagedHsmInner deserializedManagedHsmInner = new ManagedHsmInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedManagedHsmInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedManagedHsmInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedManagedHsmInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedManagedHsmInner.properties = ManagedHsmProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedManagedHsmInner.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedManagedHsmInner.location = reader.getString();
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedManagedHsmInner.sku = ManagedHsmSku.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedManagedHsmInner.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedManagedHsmInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedHsmInner;
        }));
    }
}

