/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.fluent.models.PrivateLinkResourceProperties;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class PrivateLinkResource
extends ProxyResource {
    private PrivateLinkResourceProperties innerProperties;
    private String location;
    private Map<String, String> tags;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private PrivateLinkResource() {
    }

    private PrivateLinkResourceProperties innerProperties() {
        return this.innerProperties;
    }

    public String location() {
        return this.location;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String groupId() {
        return this.innerProperties() == null ? null : this.innerProperties().groupId();
    }

    public List<String> requiredMembers() {
        return this.innerProperties() == null ? null : this.innerProperties().requiredMembers();
    }

    public List<String> requiredZoneNames() {
        return this.innerProperties() == null ? null : this.innerProperties().requiredZoneNames();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static PrivateLinkResource fromJson(JsonReader jsonReader) throws IOException {
        return (PrivateLinkResource)((Object)jsonReader.readObject(reader -> {
            PrivateLinkResource deserializedPrivateLinkResource = new PrivateLinkResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedPrivateLinkResource.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPrivateLinkResource.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPrivateLinkResource.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPrivateLinkResource.innerProperties = PrivateLinkResourceProperties.fromJson(reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedPrivateLinkResource.location = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedPrivateLinkResource.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedPrivateLinkResource.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrivateLinkResource;
        }));
    }
}

