/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.fluent.models.MhsmPrivateEndpointConnectionProperties;
import com.azure.resourcemanager.keyvault.models.MhsmPrivateEndpoint;
import com.azure.resourcemanager.keyvault.models.MhsmPrivateLinkServiceConnectionState;
import com.azure.resourcemanager.keyvault.models.PrivateEndpointConnectionProvisioningState;
import java.io.IOException;

public final class MhsmPrivateEndpointConnectionItem
implements JsonSerializable<MhsmPrivateEndpointConnectionItem> {
    private String id;
    private String etag;
    private MhsmPrivateEndpointConnectionProperties innerProperties;

    private MhsmPrivateEndpointConnectionItem() {
    }

    public String id() {
        return this.id;
    }

    public String etag() {
        return this.etag;
    }

    private MhsmPrivateEndpointConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    public MhsmPrivateEndpoint privateEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpoint();
    }

    public MhsmPrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkServiceConnectionState();
    }

    public PrivateEndpointConnectionProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("etag", this.etag);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static MhsmPrivateEndpointConnectionItem fromJson(JsonReader jsonReader) throws IOException {
        return (MhsmPrivateEndpointConnectionItem)jsonReader.readObject(reader -> {
            MhsmPrivateEndpointConnectionItem deserializedMhsmPrivateEndpointConnectionItem = new MhsmPrivateEndpointConnectionItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMhsmPrivateEndpointConnectionItem.id = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedMhsmPrivateEndpointConnectionItem.etag = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedMhsmPrivateEndpointConnectionItem.innerProperties = MhsmPrivateEndpointConnectionProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMhsmPrivateEndpointConnectionItem;
        });
    }
}

