/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.models.DimensionProperties;
import java.io.IOException;
import java.util.List;

public final class MetricSpecification
implements JsonSerializable<MetricSpecification> {
    private String name;
    private String displayName;
    private String displayDescription;
    private String unit;
    private String aggregationType;
    private List<String> supportedAggregationTypes;
    private List<String> supportedTimeGrainTypes;
    private String lockAggregationType;
    private List<DimensionProperties> dimensions;
    private Boolean fillGapWithZero;
    private String internalMetricName;

    private MetricSpecification() {
    }

    public String name() {
        return this.name;
    }

    public String displayName() {
        return this.displayName;
    }

    public String displayDescription() {
        return this.displayDescription;
    }

    public String unit() {
        return this.unit;
    }

    public String aggregationType() {
        return this.aggregationType;
    }

    public List<String> supportedAggregationTypes() {
        return this.supportedAggregationTypes;
    }

    public List<String> supportedTimeGrainTypes() {
        return this.supportedTimeGrainTypes;
    }

    public String lockAggregationType() {
        return this.lockAggregationType;
    }

    public List<DimensionProperties> dimensions() {
        return this.dimensions;
    }

    public Boolean fillGapWithZero() {
        return this.fillGapWithZero;
    }

    public String internalMetricName() {
        return this.internalMetricName;
    }

    public void validate() {
        if (this.dimensions() != null) {
            this.dimensions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("displayDescription", this.displayDescription);
        jsonWriter.writeStringField("unit", this.unit);
        jsonWriter.writeStringField("aggregationType", this.aggregationType);
        jsonWriter.writeArrayField("supportedAggregationTypes", this.supportedAggregationTypes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("supportedTimeGrainTypes", this.supportedTimeGrainTypes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("lockAggregationType", this.lockAggregationType);
        jsonWriter.writeArrayField("dimensions", this.dimensions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("fillGapWithZero", this.fillGapWithZero);
        jsonWriter.writeStringField("internalMetricName", this.internalMetricName);
        return jsonWriter.writeEndObject();
    }

    public static MetricSpecification fromJson(JsonReader jsonReader) throws IOException {
        return (MetricSpecification)jsonReader.readObject(reader -> {
            MetricSpecification deserializedMetricSpecification = new MetricSpecification();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedMetricSpecification.name = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMetricSpecification.displayName = reader.getString();
                    continue;
                }
                if ("displayDescription".equals(fieldName)) {
                    deserializedMetricSpecification.displayDescription = reader.getString();
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    deserializedMetricSpecification.unit = reader.getString();
                    continue;
                }
                if ("aggregationType".equals(fieldName)) {
                    deserializedMetricSpecification.aggregationType = reader.getString();
                    continue;
                }
                if ("supportedAggregationTypes".equals(fieldName)) {
                    List supportedAggregationTypes;
                    deserializedMetricSpecification.supportedAggregationTypes = supportedAggregationTypes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("supportedTimeGrainTypes".equals(fieldName)) {
                    List supportedTimeGrainTypes;
                    deserializedMetricSpecification.supportedTimeGrainTypes = supportedTimeGrainTypes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("lockAggregationType".equals(fieldName)) {
                    deserializedMetricSpecification.lockAggregationType = reader.getString();
                    continue;
                }
                if ("dimensions".equals(fieldName)) {
                    List dimensions;
                    deserializedMetricSpecification.dimensions = dimensions = reader.readArray(reader1 -> DimensionProperties.fromJson(reader1));
                    continue;
                }
                if ("fillGapWithZero".equals(fieldName)) {
                    deserializedMetricSpecification.fillGapWithZero = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("internalMetricName".equals(fieldName)) {
                    deserializedMetricSpecification.internalMetricName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricSpecification;
        });
    }
}

