/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.implementation.models;

import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ResourceListResult
implements JsonSerializable<ResourceListResult> {
    private List<Resource> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(ResourceListResult.class);

    private ResourceListResult() {
    }

    public List<Resource> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model ResourceListResult"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ResourceListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceListResult)jsonReader.readObject(reader -> {
            ResourceListResult deserializedResourceListResult = new ResourceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedResourceListResult.value = value = reader.readArray(reader1 -> Resource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedResourceListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceListResult;
        });
    }
}

