/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.models.SecretProperties;
import java.io.IOException;
import java.util.Map;

public final class SecretInner
extends Resource {
    private SecretProperties properties;
    private String location;
    private Map<String, String> tags;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(SecretInner.class);

    private SecretInner() {
    }

    public SecretProperties properties() {
        return this.properties;
    }

    public String location() {
        return this.location;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model SecretInner"));
        }
        this.properties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static SecretInner fromJson(JsonReader jsonReader) throws IOException {
        return (SecretInner)((Object)jsonReader.readObject(reader -> {
            SecretInner deserializedSecretInner = new SecretInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSecretInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSecretInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSecretInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSecretInner.properties = SecretProperties.fromJson(reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedSecretInner.location = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedSecretInner.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedSecretInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecretInner;
        }));
    }
}

