/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.fluent.models.KeyProperties;
import com.azure.resourcemanager.keyvault.models.JsonWebKeyCurveName;
import com.azure.resourcemanager.keyvault.models.JsonWebKeyOperation;
import com.azure.resourcemanager.keyvault.models.JsonWebKeyType;
import com.azure.resourcemanager.keyvault.models.KeyAttributes;
import com.azure.resourcemanager.keyvault.models.KeyReleasePolicy;
import com.azure.resourcemanager.keyvault.models.RotationPolicy;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class KeyInner
extends Resource {
    private KeyProperties innerProperties = new KeyProperties();
    private String location;
    private Map<String, String> tags;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(KeyInner.class);

    private KeyInner() {
    }

    private KeyProperties innerProperties() {
        return this.innerProperties;
    }

    public String location() {
        return this.location;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public KeyAttributes attributes() {
        return this.innerProperties() == null ? null : this.innerProperties().attributes();
    }

    public JsonWebKeyType kty() {
        return this.innerProperties() == null ? null : this.innerProperties().kty();
    }

    public List<JsonWebKeyOperation> keyOps() {
        return this.innerProperties() == null ? null : this.innerProperties().keyOps();
    }

    public Integer keySize() {
        return this.innerProperties() == null ? null : this.innerProperties().keySize();
    }

    public JsonWebKeyCurveName curveName() {
        return this.innerProperties() == null ? null : this.innerProperties().curveName();
    }

    public String keyUri() {
        return this.innerProperties() == null ? null : this.innerProperties().keyUri();
    }

    public String keyUriWithVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().keyUriWithVersion();
    }

    public RotationPolicy rotationPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().rotationPolicy();
    }

    public KeyReleasePolicy releasePolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().releasePolicy();
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model KeyInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static KeyInner fromJson(JsonReader jsonReader) throws IOException {
        return (KeyInner)((Object)jsonReader.readObject(reader -> {
            KeyInner deserializedKeyInner = new KeyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedKeyInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedKeyInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedKeyInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedKeyInner.innerProperties = KeyProperties.fromJson(reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedKeyInner.location = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedKeyInner.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedKeyInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyInner;
        }));
    }
}

