// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * SKU details.
 */
@Fluent
public final class Sku implements JsonSerializable<Sku> {

    /*
     * SKU family name
     */
    private SkuFamily family = SkuFamily.A;

    /*
     * SKU name to specify whether the key vault is a standard vault or a premium vault.
     */
    private SkuName name;

    /**
     * Creates an instance of Sku class.
     */
    public Sku() {
    }

    /**
     * Get the family property: SKU family name.
     *
     * @return the family value.
     */
    public SkuFamily family() {
        return this.family;
    }

    /**
     * Set the family property: SKU family name.
     *
     * @param family the family value to set.
     * @return the Sku object itself.
     */
    public Sku withFamily(SkuFamily family) {
        this.family = family;
        return this;
    }

    /**
     * Get the name property: SKU name to specify whether the key vault is a standard vault or a premium vault.
     *
     * @return the name value.
     */
    public SkuName name() {
        return this.name;
    }

    /**
     * Set the name property: SKU name to specify whether the key vault is a standard vault or a premium vault.
     *
     * @param name the name value to set.
     * @return the Sku object itself.
     */
    public Sku withName(SkuName name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (family() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property family in model Sku"));
        }
        if (name() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property name in model Sku"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(Sku.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("family", this.family == null ? null : this.family.toString());
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Sku from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of Sku if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the Sku.
     */
    public static Sku fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Sku deserializedSku = new Sku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("family".equals(fieldName)) {
                    deserializedSku.family = SkuFamily.fromString(reader.getString());
                } else if ("name".equals(fieldName)) {
                    deserializedSku.name = SkuName.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedSku;
        });
    }
}
