// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Provisioning state.
 */
public final class ProvisioningState extends ExpandableStringEnum<ProvisioningState> {
    /**
     * The managed HSM Pool has been full provisioned.
     */
    public static final ProvisioningState SUCCEEDED = fromString("Succeeded");

    /**
     * The managed HSM Pool is currently being provisioned.
     */
    public static final ProvisioningState PROVISIONING = fromString("Provisioning");

    /**
     * Provisioning of the managed HSM Pool has failed.
     */
    public static final ProvisioningState FAILED = fromString("Failed");

    /**
     * The managed HSM Pool is currently being updated.
     */
    public static final ProvisioningState UPDATING = fromString("Updating");

    /**
     * The managed HSM Pool is currently being deleted.
     */
    public static final ProvisioningState DELETING = fromString("Deleting");

    /**
     * The managed HSM pool is ready for normal use.
     */
    public static final ProvisioningState ACTIVATED = fromString("Activated");

    /**
     * The managed HSM pool is waiting for a security domain restore action.
     */
    public static final ProvisioningState SECURITY_DOMAIN_RESTORE = fromString("SecurityDomainRestore");

    /**
     * The managed HSM pool is being restored from full HSM backup.
     */
    public static final ProvisioningState RESTORING = fromString("Restoring");

    /**
     * Creates a new instance of ProvisioningState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ProvisioningState() {
    }

    /**
     * Creates or finds a ProvisioningState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ProvisioningState.
     */
    public static ProvisioningState fromString(String name) {
        return fromString(name, ProvisioningState.class);
    }

    /**
     * Gets known ProvisioningState values.
     * 
     * @return known ProvisioningState values.
     */
    public static Collection<ProvisioningState> values() {
        return values(ProvisioningState.class);
    }
}
