// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Permissions the identity has for keys, secrets, certificates and storage.
 */
@Fluent
public final class Permissions implements JsonSerializable<Permissions> {
    /*
     * Permissions to keys
     */
    private List<KeyPermissions> keys;

    /*
     * Permissions to secrets
     */
    private List<SecretPermissions> secrets;

    /*
     * Permissions to certificates
     */
    private List<CertificatePermissions> certificates;

    /*
     * Permissions to storage accounts
     */
    private List<StoragePermissions> storage;

    /**
     * Creates an instance of Permissions class.
     */
    public Permissions() {
    }

    /**
     * Get the keys property: Permissions to keys.
     * 
     * @return the keys value.
     */
    public List<KeyPermissions> keys() {
        return this.keys;
    }

    /**
     * Set the keys property: Permissions to keys.
     * 
     * @param keys the keys value to set.
     * @return the Permissions object itself.
     */
    public Permissions withKeys(List<KeyPermissions> keys) {
        this.keys = keys;
        return this;
    }

    /**
     * Get the secrets property: Permissions to secrets.
     * 
     * @return the secrets value.
     */
    public List<SecretPermissions> secrets() {
        return this.secrets;
    }

    /**
     * Set the secrets property: Permissions to secrets.
     * 
     * @param secrets the secrets value to set.
     * @return the Permissions object itself.
     */
    public Permissions withSecrets(List<SecretPermissions> secrets) {
        this.secrets = secrets;
        return this;
    }

    /**
     * Get the certificates property: Permissions to certificates.
     * 
     * @return the certificates value.
     */
    public List<CertificatePermissions> certificates() {
        return this.certificates;
    }

    /**
     * Set the certificates property: Permissions to certificates.
     * 
     * @param certificates the certificates value to set.
     * @return the Permissions object itself.
     */
    public Permissions withCertificates(List<CertificatePermissions> certificates) {
        this.certificates = certificates;
        return this;
    }

    /**
     * Get the storage property: Permissions to storage accounts.
     * 
     * @return the storage value.
     */
    public List<StoragePermissions> storage() {
        return this.storage;
    }

    /**
     * Set the storage property: Permissions to storage accounts.
     * 
     * @param storage the storage value to set.
     * @return the Permissions object itself.
     */
    public Permissions withStorage(List<StoragePermissions> storage) {
        this.storage = storage;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("keys", this.keys,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("secrets", this.secrets,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("certificates", this.certificates,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("storage", this.storage,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Permissions from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Permissions if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the Permissions.
     */
    public static Permissions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Permissions deserializedPermissions = new Permissions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("keys".equals(fieldName)) {
                    List<KeyPermissions> keys
                        = reader.readArray(reader1 -> KeyPermissions.fromString(reader1.getString()));
                    deserializedPermissions.keys = keys;
                } else if ("secrets".equals(fieldName)) {
                    List<SecretPermissions> secrets
                        = reader.readArray(reader1 -> SecretPermissions.fromString(reader1.getString()));
                    deserializedPermissions.secrets = secrets;
                } else if ("certificates".equals(fieldName)) {
                    List<CertificatePermissions> certificates
                        = reader.readArray(reader1 -> CertificatePermissions.fromString(reader1.getString()));
                    deserializedPermissions.certificates = certificates;
                } else if ("storage".equals(fieldName)) {
                    List<StoragePermissions> storage
                        = reader.readArray(reader1 -> StoragePermissions.fromString(reader1.getString()));
                    deserializedPermissions.storage = storage;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPermissions;
        });
    }
}
