// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A rule governing the accessibility of a managed hsm pool from a specific service tags.
 */
@Fluent
public final class MhsmServiceTagRule implements JsonSerializable<MhsmServiceTagRule> {
    /*
     * Name of the service tag.
     */
    private String tag;

    /**
     * Creates an instance of MhsmServiceTagRule class.
     */
    public MhsmServiceTagRule() {
    }

    /**
     * Get the tag property: Name of the service tag.
     * 
     * @return the tag value.
     */
    public String tag() {
        return this.tag;
    }

    /**
     * Set the tag property: Name of the service tag.
     * 
     * @param tag the tag value to set.
     * @return the MhsmServiceTagRule object itself.
     */
    public MhsmServiceTagRule withTag(String tag) {
        this.tag = tag;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (tag() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property tag in model MhsmServiceTagRule"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(MhsmServiceTagRule.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tag", this.tag);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MhsmServiceTagRule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MhsmServiceTagRule if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MhsmServiceTagRule.
     */
    public static MhsmServiceTagRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MhsmServiceTagRule deserializedMhsmServiceTagRule = new MhsmServiceTagRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tag".equals(fieldName)) {
                    deserializedMhsmServiceTagRule.tag = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMhsmServiceTagRule;
        });
    }
}
