// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.fluent.models.MhsmPrivateLinkResourceProperties;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * A private link resource.
 */
@Immutable
public final class MhsmPrivateLinkResource extends ManagedHsmResource {
    /*
     * Resource properties.
     */
    private MhsmPrivateLinkResourceProperties innerProperties;

    /*
     * Managed service identity (system assigned and/or user assigned identities)
     */
    private ManagedServiceIdentity identity;

    /*
     * Metadata pertaining to creation and last modification of the key vault resource.
     */
    private SystemData systemData;

    /*
     * Resource tags
     */
    private Map<String, String> tags;

    /*
     * SKU details
     */
    private ManagedHsmSku sku;

    /*
     * The supported Azure location where the managed HSM Pool should be created.
     */
    private String location;

    /*
     * The resource type of the managed HSM Pool.
     */
    private String type;

    /*
     * The name of the managed HSM Pool.
     */
    private String name;

    /*
     * The Azure Resource Manager resource ID for the managed HSM Pool.
     */
    private String id;

    /**
     * Creates an instance of MhsmPrivateLinkResource class.
     */
    private MhsmPrivateLinkResource() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private MhsmPrivateLinkResourceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the identity property: Managed service identity (system assigned and/or user assigned identities).
     * 
     * @return the identity value.
     */
    @Override
    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    /**
     * Get the systemData property: Metadata pertaining to creation and last modification of the key vault resource.
     * 
     * @return the systemData value.
     */
    @Override
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the tags property: Resource tags.
     * 
     * @return the tags value.
     */
    @Override
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Get the sku property: SKU details.
     * 
     * @return the sku value.
     */
    @Override
    public ManagedHsmSku sku() {
        return this.sku;
    }

    /**
     * Get the location property: The supported Azure location where the managed HSM Pool should be created.
     * 
     * @return the location value.
     */
    @Override
    public String location() {
        return this.location;
    }

    /**
     * Get the type property: The resource type of the managed HSM Pool.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the managed HSM Pool.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: The Azure Resource Manager resource ID for the managed HSM Pool.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the groupId property: Group identifier of private link resource.
     * 
     * @return the groupId value.
     */
    public String groupId() {
        return this.innerProperties() == null ? null : this.innerProperties().groupId();
    }

    /**
     * Get the requiredMembers property: Required member names of private link resource.
     * 
     * @return the requiredMembers value.
     */
    public List<String> requiredMembers() {
        return this.innerProperties() == null ? null : this.innerProperties().requiredMembers();
    }

    /**
     * Get the requiredZoneNames property: Required DNS zone names of the the private link resource.
     * 
     * @return the requiredZoneNames value.
     */
    public List<String> requiredZoneNames() {
        return this.innerProperties() == null ? null : this.innerProperties().requiredZoneNames();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
        if (sku() != null) {
            sku().validate();
        }
        if (identity() != null) {
            identity().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeJsonField("sku", sku());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", identity());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MhsmPrivateLinkResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MhsmPrivateLinkResource if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MhsmPrivateLinkResource.
     */
    public static MhsmPrivateLinkResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MhsmPrivateLinkResource deserializedMhsmPrivateLinkResource = new MhsmPrivateLinkResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMhsmPrivateLinkResource.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedMhsmPrivateLinkResource.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedMhsmPrivateLinkResource.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedMhsmPrivateLinkResource.location = reader.getString();
                } else if ("sku".equals(fieldName)) {
                    deserializedMhsmPrivateLinkResource.sku = ManagedHsmSku.fromJson(reader);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedMhsmPrivateLinkResource.tags = tags;
                } else if ("systemData".equals(fieldName)) {
                    deserializedMhsmPrivateLinkResource.systemData = SystemData.fromJson(reader);
                } else if ("identity".equals(fieldName)) {
                    deserializedMhsmPrivateLinkResource.identity = ManagedServiceIdentity.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedMhsmPrivateLinkResource.innerProperties
                        = MhsmPrivateLinkResourceProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMhsmPrivateLinkResource;
        });
    }
}
