// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.fluent.models.MhsmPrivateEndpointConnectionProperties;
import java.io.IOException;

/**
 * Private endpoint connection item.
 */
@Immutable
public final class MhsmPrivateEndpointConnectionItem implements JsonSerializable<MhsmPrivateEndpointConnectionItem> {
    /*
     * Id of private endpoint connection.
     */
    private String id;

    /*
     * Modified whenever there is a change in the state of private endpoint connection.
     */
    private String etag;

    /*
     * Private endpoint connection properties.
     */
    private MhsmPrivateEndpointConnectionProperties innerProperties;

    /**
     * Creates an instance of MhsmPrivateEndpointConnectionItem class.
     */
    private MhsmPrivateEndpointConnectionItem() {
    }

    /**
     * Get the id property: Id of private endpoint connection.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the etag property: Modified whenever there is a change in the state of private endpoint connection.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the innerProperties property: Private endpoint connection properties.
     * 
     * @return the innerProperties value.
     */
    private MhsmPrivateEndpointConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the privateEndpoint property: Properties of the private endpoint object.
     * 
     * @return the privateEndpoint value.
     */
    public MhsmPrivateEndpoint privateEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpoint();
    }

    /**
     * Get the privateLinkServiceConnectionState property: Approval state of the private link connection.
     * 
     * @return the privateLinkServiceConnectionState value.
     */
    public MhsmPrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkServiceConnectionState();
    }

    /**
     * Get the provisioningState property: Provisioning state of the private endpoint connection.
     * 
     * @return the provisioningState value.
     */
    public PrivateEndpointConnectionProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("etag", this.etag);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MhsmPrivateEndpointConnectionItem from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MhsmPrivateEndpointConnectionItem if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MhsmPrivateEndpointConnectionItem.
     */
    public static MhsmPrivateEndpointConnectionItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MhsmPrivateEndpointConnectionItem deserializedMhsmPrivateEndpointConnectionItem
                = new MhsmPrivateEndpointConnectionItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMhsmPrivateEndpointConnectionItem.id = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedMhsmPrivateEndpointConnectionItem.etag = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedMhsmPrivateEndpointConnectionItem.innerProperties
                        = MhsmPrivateEndpointConnectionProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMhsmPrivateEndpointConnectionItem;
        });
    }
}
