// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ManagedHsmTrigger model.
 */
@Fluent
public final class ManagedHsmTrigger implements JsonSerializable<ManagedHsmTrigger> {
    /*
     * The time duration after key creation to rotate the key. It only applies to rotate. It will be in ISO 8601
     * duration format. Eg: 'P90D', 'P1Y'.
     */
    private String timeAfterCreate;

    /*
     * The time duration before key expiring to rotate or notify. It will be in ISO 8601 duration format. Eg: 'P90D',
     * 'P1Y'.
     */
    private String timeBeforeExpiry;

    /**
     * Creates an instance of ManagedHsmTrigger class.
     */
    public ManagedHsmTrigger() {
    }

    /**
     * Get the timeAfterCreate property: The time duration after key creation to rotate the key. It only applies to
     * rotate. It will be in ISO 8601 duration format. Eg: 'P90D', 'P1Y'.
     * 
     * @return the timeAfterCreate value.
     */
    public String timeAfterCreate() {
        return this.timeAfterCreate;
    }

    /**
     * Set the timeAfterCreate property: The time duration after key creation to rotate the key. It only applies to
     * rotate. It will be in ISO 8601 duration format. Eg: 'P90D', 'P1Y'.
     * 
     * @param timeAfterCreate the timeAfterCreate value to set.
     * @return the ManagedHsmTrigger object itself.
     */
    public ManagedHsmTrigger withTimeAfterCreate(String timeAfterCreate) {
        this.timeAfterCreate = timeAfterCreate;
        return this;
    }

    /**
     * Get the timeBeforeExpiry property: The time duration before key expiring to rotate or notify. It will be in ISO
     * 8601 duration format. Eg: 'P90D', 'P1Y'.
     * 
     * @return the timeBeforeExpiry value.
     */
    public String timeBeforeExpiry() {
        return this.timeBeforeExpiry;
    }

    /**
     * Set the timeBeforeExpiry property: The time duration before key expiring to rotate or notify. It will be in ISO
     * 8601 duration format. Eg: 'P90D', 'P1Y'.
     * 
     * @param timeBeforeExpiry the timeBeforeExpiry value to set.
     * @return the ManagedHsmTrigger object itself.
     */
    public ManagedHsmTrigger withTimeBeforeExpiry(String timeBeforeExpiry) {
        this.timeBeforeExpiry = timeBeforeExpiry;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timeAfterCreate", this.timeAfterCreate);
        jsonWriter.writeStringField("timeBeforeExpiry", this.timeBeforeExpiry);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedHsmTrigger from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedHsmTrigger if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedHsmTrigger.
     */
    public static ManagedHsmTrigger fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedHsmTrigger deserializedManagedHsmTrigger = new ManagedHsmTrigger();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("timeAfterCreate".equals(fieldName)) {
                    deserializedManagedHsmTrigger.timeAfterCreate = reader.getString();
                } else if ("timeBeforeExpiry".equals(fieldName)) {
                    deserializedManagedHsmTrigger.timeBeforeExpiry = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedHsmTrigger;
        });
    }
}
