// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * SKU details.
 */
@Fluent
public final class ManagedHsmSku implements JsonSerializable<ManagedHsmSku> {
    /*
     * SKU Family of the managed HSM Pool
     */
    private ManagedHsmSkuFamily family;

    /*
     * SKU of the managed HSM Pool
     */
    private ManagedHsmSkuName name;

    /**
     * Creates an instance of ManagedHsmSku class.
     */
    public ManagedHsmSku() {
    }

    /**
     * Get the family property: SKU Family of the managed HSM Pool.
     * 
     * @return the family value.
     */
    public ManagedHsmSkuFamily family() {
        return this.family;
    }

    /**
     * Set the family property: SKU Family of the managed HSM Pool.
     * 
     * @param family the family value to set.
     * @return the ManagedHsmSku object itself.
     */
    public ManagedHsmSku withFamily(ManagedHsmSkuFamily family) {
        this.family = family;
        return this;
    }

    /**
     * Get the name property: SKU of the managed HSM Pool.
     * 
     * @return the name value.
     */
    public ManagedHsmSkuName name() {
        return this.name;
    }

    /**
     * Set the name property: SKU of the managed HSM Pool.
     * 
     * @param name the name value to set.
     * @return the ManagedHsmSku object itself.
     */
    public ManagedHsmSku withName(ManagedHsmSkuName name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (family() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property family in model ManagedHsmSku"));
        }
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model ManagedHsmSku"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ManagedHsmSku.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("family", this.family == null ? null : this.family.toString());
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedHsmSku from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedHsmSku if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagedHsmSku.
     */
    public static ManagedHsmSku fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedHsmSku deserializedManagedHsmSku = new ManagedHsmSku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("family".equals(fieldName)) {
                    deserializedManagedHsmSku.family = ManagedHsmSkuFamily.fromString(reader.getString());
                } else if ("name".equals(fieldName)) {
                    deserializedManagedHsmSku.name = ManagedHsmSkuName.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedHsmSku;
        });
    }
}
