// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The ManagedHsmRotationPolicy model.
 */
@Fluent
public final class ManagedHsmRotationPolicy implements JsonSerializable<ManagedHsmRotationPolicy> {
    /*
     * The attributes of key rotation policy.
     */
    private ManagedHsmKeyRotationPolicyAttributes attributes;

    /*
     * The lifetimeActions for key rotation action.
     */
    private List<ManagedHsmLifetimeAction> lifetimeActions;

    /**
     * Creates an instance of ManagedHsmRotationPolicy class.
     */
    public ManagedHsmRotationPolicy() {
    }

    /**
     * Get the attributes property: The attributes of key rotation policy.
     * 
     * @return the attributes value.
     */
    public ManagedHsmKeyRotationPolicyAttributes attributes() {
        return this.attributes;
    }

    /**
     * Set the attributes property: The attributes of key rotation policy.
     * 
     * @param attributes the attributes value to set.
     * @return the ManagedHsmRotationPolicy object itself.
     */
    public ManagedHsmRotationPolicy withAttributes(ManagedHsmKeyRotationPolicyAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    /**
     * Get the lifetimeActions property: The lifetimeActions for key rotation action.
     * 
     * @return the lifetimeActions value.
     */
    public List<ManagedHsmLifetimeAction> lifetimeActions() {
        return this.lifetimeActions;
    }

    /**
     * Set the lifetimeActions property: The lifetimeActions for key rotation action.
     * 
     * @param lifetimeActions the lifetimeActions value to set.
     * @return the ManagedHsmRotationPolicy object itself.
     */
    public ManagedHsmRotationPolicy withLifetimeActions(List<ManagedHsmLifetimeAction> lifetimeActions) {
        this.lifetimeActions = lifetimeActions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (attributes() != null) {
            attributes().validate();
        }
        if (lifetimeActions() != null) {
            lifetimeActions().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("attributes", this.attributes);
        jsonWriter.writeArrayField("lifetimeActions", this.lifetimeActions,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedHsmRotationPolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedHsmRotationPolicy if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedHsmRotationPolicy.
     */
    public static ManagedHsmRotationPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedHsmRotationPolicy deserializedManagedHsmRotationPolicy = new ManagedHsmRotationPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("attributes".equals(fieldName)) {
                    deserializedManagedHsmRotationPolicy.attributes
                        = ManagedHsmKeyRotationPolicyAttributes.fromJson(reader);
                } else if ("lifetimeActions".equals(fieldName)) {
                    List<ManagedHsmLifetimeAction> lifetimeActions
                        = reader.readArray(reader1 -> ManagedHsmLifetimeAction.fromJson(reader1));
                    deserializedManagedHsmRotationPolicy.lifetimeActions = lifetimeActions;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedHsmRotationPolicy;
        });
    }
}
