// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Managed HSM resource.
 */
@Immutable
public class ManagedHsmResource implements JsonSerializable<ManagedHsmResource> {
    /*
     * The Azure Resource Manager resource ID for the managed HSM Pool.
     */
    private String id;

    /*
     * The name of the managed HSM Pool.
     */
    private String name;

    /*
     * The resource type of the managed HSM Pool.
     */
    private String type;

    /*
     * The supported Azure location where the managed HSM Pool should be created.
     */
    private String location;

    /*
     * SKU details
     */
    private ManagedHsmSku sku;

    /*
     * Resource tags
     */
    private Map<String, String> tags;

    /*
     * Metadata pertaining to creation and last modification of the key vault resource.
     */
    private SystemData systemData;

    /*
     * Managed service identity (system assigned and/or user assigned identities)
     */
    private ManagedServiceIdentity identity;

    /**
     * Creates an instance of ManagedHsmResource class.
     */
    protected ManagedHsmResource() {
    }

    /**
     * Get the id property: The Azure Resource Manager resource ID for the managed HSM Pool.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The Azure Resource Manager resource ID for the managed HSM Pool.
     * 
     * @param id the id value to set.
     * @return the ManagedHsmResource object itself.
     */
    ManagedHsmResource withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: The name of the managed HSM Pool.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the managed HSM Pool.
     * 
     * @param name the name value to set.
     * @return the ManagedHsmResource object itself.
     */
    ManagedHsmResource withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: The resource type of the managed HSM Pool.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: The resource type of the managed HSM Pool.
     * 
     * @param type the type value to set.
     * @return the ManagedHsmResource object itself.
     */
    ManagedHsmResource withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the location property: The supported Azure location where the managed HSM Pool should be created.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: The supported Azure location where the managed HSM Pool should be created.
     * 
     * @param location the location value to set.
     * @return the ManagedHsmResource object itself.
     */
    ManagedHsmResource withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the sku property: SKU details.
     * 
     * @return the sku value.
     */
    public ManagedHsmSku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: SKU details.
     * 
     * @param sku the sku value to set.
     * @return the ManagedHsmResource object itself.
     */
    ManagedHsmResource withSku(ManagedHsmSku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the tags property: Resource tags.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Resource tags.
     * 
     * @param tags the tags value to set.
     * @return the ManagedHsmResource object itself.
     */
    ManagedHsmResource withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the systemData property: Metadata pertaining to creation and last modification of the key vault resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Set the systemData property: Metadata pertaining to creation and last modification of the key vault resource.
     * 
     * @param systemData the systemData value to set.
     * @return the ManagedHsmResource object itself.
     */
    ManagedHsmResource withSystemData(SystemData systemData) {
        this.systemData = systemData;
        return this;
    }

    /**
     * Get the identity property: Managed service identity (system assigned and/or user assigned identities).
     * 
     * @return the identity value.
     */
    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    /**
     * Set the identity property: Managed service identity (system assigned and/or user assigned identities).
     * 
     * @param identity the identity value to set.
     * @return the ManagedHsmResource object itself.
     */
    ManagedHsmResource withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sku() != null) {
            sku().validate();
        }
        if (identity() != null) {
            identity().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", this.identity);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedHsmResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedHsmResource if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedHsmResource.
     */
    public static ManagedHsmResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedHsmResource deserializedManagedHsmResource = new ManagedHsmResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedManagedHsmResource.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedManagedHsmResource.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedManagedHsmResource.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedManagedHsmResource.location = reader.getString();
                } else if ("sku".equals(fieldName)) {
                    deserializedManagedHsmResource.sku = ManagedHsmSku.fromJson(reader);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedManagedHsmResource.tags = tags;
                } else if ("systemData".equals(fieldName)) {
                    deserializedManagedHsmResource.systemData = SystemData.fromJson(reader);
                } else if ("identity".equals(fieldName)) {
                    deserializedManagedHsmResource.identity = ManagedServiceIdentity.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedHsmResource;
        });
    }
}
