// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.fluent.models.ManagedHsmKeyProperties;
import java.io.IOException;
import java.util.Map;

/**
 * The parameters used to create a key.
 */
@Fluent
public final class ManagedHsmKeyCreateParameters implements JsonSerializable<ManagedHsmKeyCreateParameters> {
    /*
     * The tags that will be assigned to the key.
     */
    private Map<String, String> tags;

    /*
     * The properties of the key to be created.
     */
    private ManagedHsmKeyProperties properties;

    /**
     * Creates an instance of ManagedHsmKeyCreateParameters class.
     */
    public ManagedHsmKeyCreateParameters() {
    }

    /**
     * Get the tags property: The tags that will be assigned to the key.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: The tags that will be assigned to the key.
     * 
     * @param tags the tags value to set.
     * @return the ManagedHsmKeyCreateParameters object itself.
     */
    public ManagedHsmKeyCreateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the properties property: The properties of the key to be created.
     * 
     * @return the properties value.
     */
    public ManagedHsmKeyProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: The properties of the key to be created.
     * 
     * @param properties the properties value to set.
     * @return the ManagedHsmKeyCreateParameters object itself.
     */
    public ManagedHsmKeyCreateParameters withProperties(ManagedHsmKeyProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property properties in model ManagedHsmKeyCreateParameters"));
        } else {
            properties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ManagedHsmKeyCreateParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.properties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedHsmKeyCreateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedHsmKeyCreateParameters if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagedHsmKeyCreateParameters.
     */
    public static ManagedHsmKeyCreateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedHsmKeyCreateParameters deserializedManagedHsmKeyCreateParameters
                = new ManagedHsmKeyCreateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedManagedHsmKeyCreateParameters.properties = ManagedHsmKeyProperties.fromJson(reader);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedManagedHsmKeyCreateParameters.tags = tags;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedHsmKeyCreateParameters;
        });
    }
}
