// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Log specification of operation.
 */
@Immutable
public final class LogSpecification implements JsonSerializable<LogSpecification> {
    /*
     * Name of log specification.
     */
    private String name;

    /*
     * Display name of log specification.
     */
    private String displayName;

    /*
     * Blob duration of specification.
     */
    private String blobDuration;

    /**
     * Creates an instance of LogSpecification class.
     */
    private LogSpecification() {
    }

    /**
     * Get the name property: Name of log specification.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the displayName property: Display name of log specification.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Get the blobDuration property: Blob duration of specification.
     * 
     * @return the blobDuration value.
     */
    public String blobDuration() {
        return this.blobDuration;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("blobDuration", this.blobDuration);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LogSpecification from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LogSpecification if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the LogSpecification.
     */
    public static LogSpecification fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LogSpecification deserializedLogSpecification = new LogSpecification();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedLogSpecification.name = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedLogSpecification.displayName = reader.getString();
                } else if ("blobDuration".equals(fieldName)) {
                    deserializedLogSpecification.blobDuration = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLogSpecification;
        });
    }
}
