// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

/**
 * The KeyReleasePolicy model.
 */
@Fluent
public final class KeyReleasePolicy implements JsonSerializable<KeyReleasePolicy> {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    /*
     * Content type and version of key release policy
     */
    private String contentType;

    /*
     * Blob encoding the policy rules under which the key can be released.
     */
    private Base64Url data;

    /**
     * Creates an instance of KeyReleasePolicy class.
     */
    public KeyReleasePolicy() {
    }

    /**
     * Get the contentType property: Content type and version of key release policy.
     * 
     * @return the contentType value.
     */
    public String contentType() {
        return this.contentType;
    }

    /**
     * Set the contentType property: Content type and version of key release policy.
     * 
     * @param contentType the contentType value to set.
     * @return the KeyReleasePolicy object itself.
     */
    public KeyReleasePolicy withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    /**
     * Get the data property: Blob encoding the policy rules under which the key can be released.
     * 
     * @return the data value.
     */
    public byte[] data() {
        if (this.data == null) {
            return EMPTY_BYTE_ARRAY;
        }
        return this.data.decodedBytes();
    }

    /**
     * Set the data property: Blob encoding the policy rules under which the key can be released.
     * 
     * @param data the data value to set.
     * @return the KeyReleasePolicy object itself.
     */
    public KeyReleasePolicy withData(byte[] data) {
        if (data == null) {
            this.data = null;
        } else {
            this.data = Base64Url.encode(CoreUtils.clone(data));
        }
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeStringField("data", Objects.toString(this.data, null));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyReleasePolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyReleasePolicy if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the KeyReleasePolicy.
     */
    public static KeyReleasePolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyReleasePolicy deserializedKeyReleasePolicy = new KeyReleasePolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("contentType".equals(fieldName)) {
                    deserializedKeyReleasePolicy.contentType = reader.getString();
                } else if ("data".equals(fieldName)) {
                    deserializedKeyReleasePolicy.data
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyReleasePolicy;
        });
    }
}
