// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

/**
 * Properties of the deleted managed HSM.
 */
@Immutable
public final class DeletedManagedHsmProperties implements JsonSerializable<DeletedManagedHsmProperties> {
    /*
     * The resource id of the original managed HSM.
     */
    private String mhsmId;

    /*
     * The location of the original managed HSM.
     */
    private String location;

    /*
     * The deleted date.
     */
    private OffsetDateTime deletionDate;

    /*
     * The scheduled purged date.
     */
    private OffsetDateTime scheduledPurgeDate;

    /*
     * Purge protection status of the original managed HSM.
     */
    private Boolean purgeProtectionEnabled;

    /*
     * Tags of the original managed HSM.
     */
    private Map<String, String> tags;

    /**
     * Creates an instance of DeletedManagedHsmProperties class.
     */
    private DeletedManagedHsmProperties() {
    }

    /**
     * Get the mhsmId property: The resource id of the original managed HSM.
     * 
     * @return the mhsmId value.
     */
    public String mhsmId() {
        return this.mhsmId;
    }

    /**
     * Get the location property: The location of the original managed HSM.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the deletionDate property: The deleted date.
     * 
     * @return the deletionDate value.
     */
    public OffsetDateTime deletionDate() {
        return this.deletionDate;
    }

    /**
     * Get the scheduledPurgeDate property: The scheduled purged date.
     * 
     * @return the scheduledPurgeDate value.
     */
    public OffsetDateTime scheduledPurgeDate() {
        return this.scheduledPurgeDate;
    }

    /**
     * Get the purgeProtectionEnabled property: Purge protection status of the original managed HSM.
     * 
     * @return the purgeProtectionEnabled value.
     */
    public Boolean purgeProtectionEnabled() {
        return this.purgeProtectionEnabled;
    }

    /**
     * Get the tags property: Tags of the original managed HSM.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeletedManagedHsmProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeletedManagedHsmProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeletedManagedHsmProperties.
     */
    public static DeletedManagedHsmProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeletedManagedHsmProperties deserializedDeletedManagedHsmProperties = new DeletedManagedHsmProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("mhsmId".equals(fieldName)) {
                    deserializedDeletedManagedHsmProperties.mhsmId = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedDeletedManagedHsmProperties.location = reader.getString();
                } else if ("deletionDate".equals(fieldName)) {
                    deserializedDeletedManagedHsmProperties.deletionDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("scheduledPurgeDate".equals(fieldName)) {
                    deserializedDeletedManagedHsmProperties.scheduledPurgeDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("purgeProtectionEnabled".equals(fieldName)) {
                    deserializedDeletedManagedHsmProperties.purgeProtectionEnabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDeletedManagedHsmProperties.tags = tags;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeletedManagedHsmProperties;
        });
    }
}
