// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

/**
 * The object attributes managed by the KeyVault service.
 */
@Fluent
public class Attributes implements JsonSerializable<Attributes> {
    /*
     * Determines whether the object is enabled.
     */
    private Boolean enabled;

    /*
     * Not before date in seconds since 1970-01-01T00:00:00Z.
     */
    private Long notBefore;

    /*
     * Expiry date in seconds since 1970-01-01T00:00:00Z.
     */
    private Long expires;

    /*
     * Creation time in seconds since 1970-01-01T00:00:00Z.
     */
    private Long created;

    /*
     * Last updated time in seconds since 1970-01-01T00:00:00Z.
     */
    private Long updated;

    /**
     * Creates an instance of Attributes class.
     */
    public Attributes() {
    }

    /**
     * Get the enabled property: Determines whether the object is enabled.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Determines whether the object is enabled.
     * 
     * @param enabled the enabled value to set.
     * @return the Attributes object itself.
     */
    public Attributes withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the notBefore property: Not before date in seconds since 1970-01-01T00:00:00Z.
     * 
     * @return the notBefore value.
     */
    public OffsetDateTime notBefore() {
        if (this.notBefore == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.notBefore), ZoneOffset.UTC);
    }

    /**
     * Set the notBefore property: Not before date in seconds since 1970-01-01T00:00:00Z.
     * 
     * @param notBefore the notBefore value to set.
     * @return the Attributes object itself.
     */
    public Attributes withNotBefore(OffsetDateTime notBefore) {
        if (notBefore == null) {
            this.notBefore = null;
        } else {
            this.notBefore = notBefore.toEpochSecond();
        }
        return this;
    }

    /**
     * Get the expires property: Expiry date in seconds since 1970-01-01T00:00:00Z.
     * 
     * @return the expires value.
     */
    public OffsetDateTime expires() {
        if (this.expires == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.expires), ZoneOffset.UTC);
    }

    /**
     * Set the expires property: Expiry date in seconds since 1970-01-01T00:00:00Z.
     * 
     * @param expires the expires value to set.
     * @return the Attributes object itself.
     */
    public Attributes withExpires(OffsetDateTime expires) {
        if (expires == null) {
            this.expires = null;
        } else {
            this.expires = expires.toEpochSecond();
        }
        return this;
    }

    /**
     * Get the created property: Creation time in seconds since 1970-01-01T00:00:00Z.
     * 
     * @return the created value.
     */
    public OffsetDateTime created() {
        if (this.created == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.created), ZoneOffset.UTC);
    }

    /**
     * Set the created property: Creation time in seconds since 1970-01-01T00:00:00Z.
     * 
     * @param created the created value to set.
     * @return the Attributes object itself.
     */
    Attributes withCreated(OffsetDateTime created) {
        if (created == null) {
            this.created = null;
        } else {
            this.created = created.toEpochSecond();
        }
        return this;
    }

    /**
     * Get the updated property: Last updated time in seconds since 1970-01-01T00:00:00Z.
     * 
     * @return the updated value.
     */
    public OffsetDateTime updated() {
        if (this.updated == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.updated), ZoneOffset.UTC);
    }

    /**
     * Set the updated property: Last updated time in seconds since 1970-01-01T00:00:00Z.
     * 
     * @param updated the updated value to set.
     * @return the Attributes object itself.
     */
    Attributes withUpdated(OffsetDateTime updated) {
        if (updated == null) {
            this.updated = null;
        } else {
            this.updated = updated.toEpochSecond();
        }
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeNumberField("nbf", this.notBefore);
        jsonWriter.writeNumberField("exp", this.expires);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Attributes from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Attributes if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the Attributes.
     */
    public static Attributes fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Attributes deserializedAttributes = new Attributes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedAttributes.enabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("nbf".equals(fieldName)) {
                    deserializedAttributes.notBefore = reader.getNullable(JsonReader::getLong);
                } else if ("exp".equals(fieldName)) {
                    deserializedAttributes.expires = reader.getNullable(JsonReader::getLong);
                } else if ("created".equals(fieldName)) {
                    deserializedAttributes.created = reader.getNullable(JsonReader::getLong);
                } else if ("updated".equals(fieldName)) {
                    deserializedAttributes.updated = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAttributes;
        });
    }
}
